/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.DefaultClassRealm;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

public class ClassWorld {
    private Map realms = new HashMap();

    public ClassRealm newRealm(String id) throws DuplicateRealmException {
        return this.newRealm(id, null);
    }

    public ClassRealm newRealm(String id, ClassLoader classLoader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        ClassRealm realm = null;
        if (classLoader != null) {
            String parentRealmId = id + "_ParentRealm";
            DefaultClassRealm parentRealm = new DefaultClassRealm(this, parentRealmId, classLoader);
            realm = parentRealm.createChildRealm(id);
            this.realms.put(parentRealmId, parentRealm);
        } else {
            realm = new DefaultClassRealm(this, id, null);
        }
        this.realms.put(id, realm);
        return realm;
    }

    public void disposeRealm(String id) throws NoSuchRealmException {
        ClassRealm realm = this.getRealm(id);
        this.realms.remove(id);
    }

    public ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return (ClassRealm)this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    DefaultClassRealm getRealmImpl(String id) throws NoSuchRealmException {
        return (DefaultClassRealm)this.getRealm(id);
    }

    public Collection getRealms() {
        return this.realms.values();
    }

    Class loadClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }
}

