/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import org.apache.activeio.util.ByteArrayInputStream;
import org.apache.activeio.util.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.jdbc.JdbcStoreFactory;

public class JdbcStore
implements Store {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$servicemix$store$jdbc$JdbcStore == null ? (class$org$apache$servicemix$store$jdbc$JdbcStore = JdbcStore.class$("org.apache.servicemix.store.jdbc.JdbcStore")) : class$org$apache$servicemix$store$jdbc$JdbcStore));
    private JdbcStoreFactory factory;
    private String name;
    static /* synthetic */ Class class$org$apache$servicemix$store$jdbc$JdbcStore;

    public JdbcStore(JdbcStoreFactory factory, String name) {
        this.factory = factory;
        this.name = name;
    }

    public boolean hasFeature(String name) {
        return "Persistent".equals(name) || "Clustered".equals(name) && this.factory.isClustered() || "Transactional".equals(name) && this.factory.isTransactional();
    }

    public void store(String id, Object data) throws IOException {
        log.debug((Object)("Storing object with id: " + id));
        Connection connection = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)buffer);
            out.writeObject(data);
            out.close();
            connection = this.factory.getDataSource().getConnection();
            this.factory.getAdapter().doStoreData(connection, this.name + ":" + id, buffer.toByteArray());
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error storing object").initCause(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Error closing connection").initCause(e);
                }
            }
        }
    }

    public String store(Object data) throws IOException {
        String id = this.factory.getIdGenerator().generateId();
        this.store(id, data);
        return id;
    }

    public Object load(String id) throws IOException {
        log.debug((Object)("Loading object with id: " + id));
        Connection connection = null;
        try {
            connection = this.factory.getDataSource().getConnection();
            byte[] data = this.factory.getAdapter().doLoadData(connection, this.name + ":" + id);
            Object result = null;
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteArrayInputStream(data));
                result = ois.readObject();
                this.factory.getAdapter().doRemoveData(connection, this.name + ":" + id);
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error storing object").initCause(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Error closing connection").initCause(e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

