/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class KernelErrorsError
extends Error {
    private final List errors;

    public KernelErrorsError(List errors) {
        if (errors == null) {
            throw new NullPointerException("errors is null");
        }
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        ListIterator iterator = errors.listIterator();
        while (iterator.hasNext()) {
            Object error = iterator.next();
            if (error == null) {
                throw new IllegalArgumentException("Errors element " + iterator.previousIndex() + " is null");
            }
            if (error instanceof Error) continue;
            throw new IllegalArgumentException("Errors element " + iterator.previousIndex() + " is not an instance of java.lang.Error " + error.getClass() + ": " + error);
        }
        this.errors = Collections.unmodifiableList(errors);
    }

    public List getErrors() {
        return this.errors;
    }

    public String getMessage() {
        StringBuffer message = new StringBuffer();
        message.append(this.errors.size() + " Error(s) occured [");
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Error error = (Error)iterator.next();
            message.append('\"').append(error.getMessage()).append('\"');
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]").toString();
    }

    public String getLocalizedMessage() {
        StringBuffer message = new StringBuffer();
        message.append(this.errors.size() + " Error(s) occured [");
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Error error = (Error)iterator.next();
            message.append('\"').append(error.getLocalizedMessage()).append('\"');
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        return message.append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(this);
            Iterator iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                Error error = (Error)iterator.next();
                error.printStackTrace(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter writer) {
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            writer.println(this);
            Iterator iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                Error error = (Error)iterator.next();
                error.printStackTrace(writer);
            }
        }
    }
}

