/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.xbean.kernel.ForcedStopException;
import org.apache.xbean.kernel.IllegalServiceStateException;
import org.apache.xbean.kernel.InvalidServiceTypeException;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.KernelOperationInterruptedException;
import org.apache.xbean.kernel.KernelOperationTimoutException;
import org.apache.xbean.kernel.ServiceEvent;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceMonitor;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceState;
import org.apache.xbean.kernel.StartStrategies;
import org.apache.xbean.kernel.StartStrategy;
import org.apache.xbean.kernel.StopStrategy;
import org.apache.xbean.kernel.UnregisterServiceException;
import org.apache.xbean.kernel.UnsatisfiedConditionsException;
import org.apache.xbean.kernel.standard.AggregateCondition;
import org.apache.xbean.kernel.standard.NonRestartableStopCondition;
import org.apache.xbean.kernel.standard.StandardServiceContext;

public class ServiceManager
implements Comparable {
    private final Kernel kernel;
    private final long serviceId;
    private final ServiceName serviceName;
    private final ServiceFactory serviceFactory;
    private final Set serviceTypes;
    private final ClassLoader classLoader;
    private final ServiceMonitor serviceMonitor;
    private final StandardServiceContext standardServiceContext;
    private volatile ServiceState state = ServiceState.STOPPED;
    private volatile long startTime;
    private AggregateCondition startCondition;
    private AggregateCondition stopCondition;
    private volatile Object service;
    private final ReentrantLock lock = new ReentrantLock();
    private final long timeoutDuration;
    private final TimeUnit timeoutUnits;
    private String currentLockHolderOperation = "NOT-HELD";
    private final AtomicLong eventId = new AtomicLong(0L);
    private boolean recursive = false;

    public ServiceManager(Kernel kernel, long serviceId, ServiceName serviceName, ServiceFactory serviceFactory, ClassLoader classLoader, ServiceMonitor serviceMonitor, long timeoutDuration, TimeUnit timeoutUnits) {
        this.kernel = kernel;
        this.serviceId = serviceId;
        this.serviceName = serviceName;
        this.serviceFactory = serviceFactory;
        this.classLoader = classLoader;
        this.serviceMonitor = serviceMonitor;
        this.timeoutDuration = timeoutDuration;
        this.timeoutUnits = timeoutUnits;
        this.standardServiceContext = new StandardServiceContext(kernel, serviceName, classLoader);
        this.serviceTypes = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(serviceFactory.getTypes())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        if (!this.serviceFactory.isRestartable() && !this.serviceFactory.isEnabled()) {
            throw new IllegalServiceStateException("A disabled non-restartable service factory can not be initalized", this.serviceName);
        }
        this.serviceMonitor.serviceRegistered(this.createServiceEvent());
        if (!this.serviceFactory.isRestartable()) {
            try {
                this.start(false, StartStrategies.UNREGISTER);
            }
            catch (UnregisterServiceException e) {
                this.serviceMonitor.serviceUnregistered(this.createServiceEvent());
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new AssertionError((Object)cause);
            }
            this.lock("initialize");
            try {
                this.stopCondition = new NonRestartableStopCondition(this.kernel, this.serviceName, this.classLoader, (Lock)this.lock, this.serviceFactory);
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(StopStrategy stopStrategy) throws IllegalServiceStateException, UnsatisfiedConditionsException {
        block10: {
            if (!this.stop(stopStrategy)) {
                throw new IllegalServiceStateException("Service did not stop", this.serviceName);
            }
            if (!this.serviceFactory.isRestartable()) {
                this.lock("destroy");
                try {
                    if (this.state == ServiceState.STOPPED) break block10;
                    this.state = ServiceState.STARTING;
                    this.serviceMonitor.serviceStopping(this.createServiceEvent());
                    if (this.service != null) {
                        try {
                            this.serviceFactory.destroyService(this.standardServiceContext);
                        }
                        catch (Throwable e) {
                            this.serviceMonitor.serviceStopError(this.createErrorServiceEvent(e));
                        }
                    }
                    this.destroyAllConditions(this.serviceMonitor);
                    this.service = null;
                    this.startTime = 0L;
                    this.state = ServiceState.STOPPED;
                    this.serviceMonitor.serviceStopped(this.createServiceEvent());
                }
                finally {
                    this.unlock();
                }
            }
        }
        this.serviceMonitor.serviceUnregistered(this.createServiceEvent());
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public Set getServiceTypes() {
        return this.serviceTypes;
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Object getService() {
        return this.service;
    }

    public ServiceState getState() {
        return this.state;
    }

    public long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(boolean recursive, StartStrategy startStrategy) throws IllegalServiceStateException, UnregisterServiceException, UnsatisfiedConditionsException, Exception {
        block24: {
            if (!this.verifyStartable(this.state)) {
                if (recursive) {
                    this.startOwnedServices(startStrategy);
                }
                return;
            }
            shouldStartRecursive = false;
            this.lock("start");
            try {
                this.recursive = this.recursive != false || recursive != false;
                startError /* !! */  = null;
                try {
                    satisfied = false;
lbl12:
                    // 3 sources

                    while (!satisfied) {
                        if (!this.verifyStartable(this.state)) {
                            this.unlock();
                            return;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl43
                }
                catch (UnsatisfiedConditionsException e) {
                    throw e;
                }
                catch (IllegalServiceStateException e) {
                    throw e;
                }
                catch (Exception e) {
                    startError /* !! */  = e;
                    break block24;
                }
                catch (Error e) {
                    startError /* !! */  = e;
                    break block24;
                }
            }
            catch (Throwable var9_13) {
                this.unlock();
                throw var9_13;
            }
lbl-1000:
            // 1 sources

            {
                if (this.state == ServiceState.STOPPED) {
                    this.state = ServiceState.STARTING;
                    this.serviceMonitor.serviceStarting(this.createServiceEvent());
                    this.startCondition = new AggregateCondition(this.kernel, this.serviceName, this.classLoader, (Lock)this.lock, this.serviceFactory.getStartConditions());
                    this.startCondition.initialize();
                }
                if (satisfied = (unsatisfiedConditions = this.startCondition.getUnsatisfied()).isEmpty()) ** GOTO lbl12
                if (!startStrategy.waitForUnsatisfiedConditions(this.serviceName, unsatisfiedConditions)) {
                    this.serviceMonitor.serviceWaitingToStart(this.createWaitingServiceEvent(unsatisfiedConditions));
                    this.unlock();
                    return;
                }
                this.startCondition.awaitSatisfaction();
            }
            {
                ** GOTO lbl12
lbl43:
                // 1 sources

                this.service = this.serviceFactory.createService(this.standardServiceContext);
                if (this.service == null) {
                    throw new NullPointerException("Service factory return null from createService for service " + this.serviceName);
                }
                iterator = this.serviceTypes.iterator();
                while (iterator.hasNext()) {
                    type = (Class)iterator.next();
                    if (type.isInstance(this.service)) continue;
                    throw new InvalidServiceTypeException(this.serviceName, type, this.service.getClass());
                }
                this.startTime = System.currentTimeMillis();
                this.state = ServiceState.RUNNING;
                this.serviceMonitor.serviceRunning(this.createServiceEvent());
                shouldStartRecursive = this.recursive != false || recursive != false;
                this.recursive = false;
            }
        }
        if (startError /* !! */  != null) {
            try {
                if (startError /* !! */  instanceof UnregisterServiceException) {
                    throw (UnregisterServiceException)startError /* !! */ ;
                }
                startStrategy.startError(this.serviceName, startError /* !! */ );
                this.serviceMonitor.serviceStartError(this.createErrorServiceEvent(startError /* !! */ ));
            }
            finally {
                this.state = ServiceState.STOPPING;
                this.serviceMonitor.serviceStopping(this.createServiceEvent());
                this.destroyAllConditions(this.serviceMonitor);
                this.service = null;
                this.startTime = 0L;
                this.state = ServiceState.STOPPED;
                this.serviceMonitor.serviceStopped(this.createServiceEvent());
            }
        }
        this.unlock();
        if (shouldStartRecursive) {
            this.startOwnedServices(startStrategy);
        }
    }

    private void startOwnedServices(StartStrategy startStrategy) throws IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        Set ownedServices = this.serviceFactory.getOwnedServices();
        if (ownedServices == null) {
            throw new NullPointerException("serviceFactory.getOwnedServices() returned null");
        }
        Iterator iterator = ownedServices.iterator();
        while (iterator.hasNext()) {
            ServiceName ownedService = (ServiceName)iterator.next();
            try {
                this.kernel.startServiceRecursive(ownedService, startStrategy);
            }
            catch (ServiceNotFoundException ignored) {
            }
            catch (IllegalServiceStateException ignored) {}
        }
    }

    private boolean verifyStartable(ServiceState state) throws IllegalServiceStateException {
        if (state == ServiceState.RUNNING) {
            return false;
        }
        if (state == ServiceState.STOPPING) {
            throw new IllegalServiceStateException("A stopping service can not be started", this.serviceName);
        }
        if (state == ServiceState.STOPPED && !this.serviceFactory.isEnabled()) {
            throw new IllegalServiceStateException("Service is disabled", this.serviceName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean stop(StopStrategy stopStrategy) throws UnsatisfiedConditionsException {
        ServiceState initialState = this.state;
        if (initialState == ServiceState.STOPPED) {
            return true;
        }
        this.lock("stop");
        try {
            boolean satisfied = false;
            while (!satisfied) {
                Set unsatisfiedConditions;
                if (this.state == ServiceState.STOPPED) {
                    boolean bl = true;
                    this.unlock();
                    return bl;
                }
                if (this.stopCondition == null) {
                    this.serviceMonitor.serviceStopping(this.createServiceEvent());
                    this.state = ServiceState.STOPPING;
                    this.stopCondition = new AggregateCondition(this.kernel, this.serviceName, this.classLoader, (Lock)this.lock, this.serviceFactory.getStopConditions());
                    this.stopCondition.initialize();
                }
                if (!(satisfied = (unsatisfiedConditions = this.stopCondition.getUnsatisfied()).isEmpty())) {
                    if (!stopStrategy.waitForUnsatisfiedConditions(this.serviceName, unsatisfiedConditions)) {
                        this.serviceMonitor.serviceWaitingToStop(this.createWaitingServiceEvent(unsatisfiedConditions));
                        boolean bl = false;
                        this.unlock();
                        return bl;
                    }
                    this.stopCondition.awaitSatisfaction();
                }
                try {
                }
                catch (UnsatisfiedConditionsException e) {
                    throw e;
                }
                catch (ForcedStopException e) {
                    this.serviceMonitor.serviceStopError(this.createErrorServiceEvent(e));
                    break;
                }
                catch (Exception e) {
                    this.serviceMonitor.serviceStopError(this.createErrorServiceEvent(e));
                    break;
                }
                catch (Error e) {
                    this.serviceMonitor.serviceStopError(this.createErrorServiceEvent(e));
                    break;
                }
            }
            if (this.serviceFactory.isRestartable()) {
                if (this.service != null) {
                    try {
                        this.serviceFactory.destroyService(this.standardServiceContext);
                    }
                    catch (Throwable e) {
                        this.serviceMonitor.serviceStopError(this.createErrorServiceEvent(e));
                    }
                }
                this.destroyAllConditions(this.serviceMonitor);
                this.service = null;
                this.startTime = 0L;
                this.state = ServiceState.STOPPED;
                this.serviceMonitor.serviceStopped(this.createServiceEvent());
            }
            boolean bl = true;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            this.unlock();
            throw throwable;
        }
    }

    private void destroyAllConditions(ServiceMonitor monitor) {
        Throwable stopError;
        Iterator iterator;
        List errors;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Current thread must hold lock before calling destroyAllConditions");
        }
        if (this.startCondition != null) {
            errors = this.startCondition.destroy();
            iterator = errors.iterator();
            while (iterator.hasNext()) {
                stopError = (Throwable)iterator.next();
                monitor.serviceStopError(this.createErrorServiceEvent(stopError));
            }
            this.startCondition = null;
        }
        if (this.stopCondition != null) {
            errors = this.stopCondition.destroy();
            iterator = errors.iterator();
            while (iterator.hasNext()) {
                stopError = (Throwable)iterator.next();
                monitor.serviceStopError(this.createErrorServiceEvent(stopError));
            }
            this.stopCondition = null;
        }
    }

    private void lock(String operationName) throws IllegalStateException, KernelOperationTimoutException, KernelOperationInterruptedException {
        if (this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Current thread holds lock for " + this.currentLockHolderOperation + " and lock can not be reacquired for " + operationName + " on " + this.serviceName);
        }
        try {
            if (!this.lock.tryLock(this.timeoutDuration, this.timeoutUnits)) {
                throw new KernelOperationTimoutException("Could not obtain lock for " + operationName + " operation on " + this.serviceName + " within " + this.timeoutDuration + " " + this.timeoutUnits.toString().toLowerCase(), this.serviceName, operationName);
            }
            this.currentLockHolderOperation = operationName;
        }
        catch (InterruptedException e) {
            throw new KernelOperationInterruptedException("Interrupted while attempting to obtain lock for " + operationName + " operation on " + this.serviceName, e, this.serviceName, operationName);
        }
    }

    private void unlock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Not owner");
        }
        this.currentLockHolderOperation = "NOT-HELD";
        this.lock.unlock();
    }

    private ServiceEvent createServiceEvent() {
        return new ServiceEvent(this.eventId.getAndIncrement(), this.kernel, this.serviceName, this.serviceFactory, this.classLoader, this.service, null, null);
    }

    private ServiceEvent createWaitingServiceEvent(Set unsatisfiedConditions) {
        return new ServiceEvent(this.eventId.getAndIncrement(), this.kernel, this.serviceName, this.serviceFactory, this.classLoader, this.service, null, unsatisfiedConditions);
    }

    private ServiceEvent createErrorServiceEvent(Throwable cause) {
        return new ServiceEvent(this.eventId.getAndIncrement(), this.kernel, this.serviceName, this.serviceFactory, this.classLoader, null, cause, null);
    }

    public int hashCode() {
        return (int)(this.serviceId ^ this.serviceId >>> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof ServiceManager) {
            return this.serviceId == ((ServiceManager)o).serviceId;
        }
        return false;
    }

    public int compareTo(Object o) {
        ServiceManager serviceManager = (ServiceManager)o;
        if (this.serviceId < serviceManager.serviceId) {
            return -1;
        }
        if (this.serviceId > serviceManager.serviceId) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[ServiceManager: serviceId=" + this.serviceId + ", serviceName=" + this.serviceName + ", state=" + this.state + "]";
    }
}

