/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel.standard;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xbean.kernel.IllegalServiceStateException;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.KernelErrorsError;
import org.apache.xbean.kernel.KernelFactory;
import org.apache.xbean.kernel.KernelMonitor;
import org.apache.xbean.kernel.ServiceAlreadyExistsException;
import org.apache.xbean.kernel.ServiceFactory;
import org.apache.xbean.kernel.ServiceMonitor;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceRegistrationException;
import org.apache.xbean.kernel.ServiceState;
import org.apache.xbean.kernel.StartStrategies;
import org.apache.xbean.kernel.StartStrategy;
import org.apache.xbean.kernel.StopStrategies;
import org.apache.xbean.kernel.StopStrategy;
import org.apache.xbean.kernel.UnregisterServiceException;
import org.apache.xbean.kernel.UnsatisfiedConditionsException;
import org.apache.xbean.kernel.standard.KernelMonitorBroadcaster;
import org.apache.xbean.kernel.standard.ServiceManager;
import org.apache.xbean.kernel.standard.ServiceManagerFactory;
import org.apache.xbean.kernel.standard.ServiceManagerRegistry;
import org.apache.xbean.kernel.standard.ServiceMonitorBroadcaster;

public class StandardKernel
implements Kernel {
    private final String kernelName;
    private final ServiceManagerRegistry serviceManagerRegistry;
    private final KernelMonitorBroadcaster kernelMonitor = new KernelMonitorBroadcaster();
    private final ServiceMonitorBroadcaster serviceMonitor = new ServiceMonitorBroadcaster(this.kernelMonitor);
    private boolean running = true;
    private final Lock destroyLock = new ReentrantLock();
    private final Condition destroyCondition = this.destroyLock.newCondition();
    private ServiceManagerFactory serviceManagerFactory;
    private ExecutorService serviceExecutor;
    private boolean ownsServiceExecutor;

    public StandardKernel(String kernelName) {
        this(kernelName, Executors.newCachedThreadPool(), 30L, TimeUnit.SECONDS);
        this.ownsServiceExecutor = true;
    }

    public StandardKernel(String kernelName, ExecutorService serviceExecutor, long timeoutDuration, TimeUnit timeoutUnits) {
        if (kernelName == null) {
            throw new NullPointerException("kernelName is null");
        }
        if (kernelName.length() == 0) {
            throw new IllegalArgumentException("kernelName must be atleast one character long");
        }
        if (serviceExecutor == null) {
            throw new NullPointerException("serviceExecutor is null");
        }
        if (timeoutUnits == null) {
            throw new NullPointerException("timeoutUnits is null");
        }
        this.kernelName = kernelName;
        this.serviceExecutor = serviceExecutor;
        this.serviceManagerFactory = new ServiceManagerFactory(this, this.serviceMonitor, (Executor)serviceExecutor, timeoutDuration, timeoutUnits);
        this.serviceManagerRegistry = new ServiceManagerRegistry(this.serviceManagerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws KernelErrorsError {
        this.destroyLock.lock();
        try {
            if (!this.running) {
                return;
            }
            this.running = false;
        }
        finally {
            this.destroyLock.unlock();
        }
        this.serviceManagerRegistry.destroy();
        if (this.ownsServiceExecutor) {
            this.serviceExecutor.shutdown();
        }
        KernelFactory.destroyInstance(this);
        this.destroyLock.lock();
        try {
            this.destroyCondition.signalAll();
        }
        finally {
            this.destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDestruction() {
        this.destroyLock.lock();
        try {
            if (!this.running) {
                return;
            }
            this.destroyCondition.awaitUninterruptibly();
        }
        finally {
            this.destroyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        this.destroyLock.lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.destroyLock.unlock();
        }
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public void registerService(ServiceName serviceName, ServiceFactory serviceFactory, ClassLoader classLoader) throws ServiceAlreadyExistsException, ServiceRegistrationException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (serviceFactory == null) {
            throw new NullPointerException("serviceFactory is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        if (!this.isRunning()) {
            throw new ServiceRegistrationException(serviceName, (Throwable)new IllegalStateException("Kernel is destroyed"));
        }
        this.serviceManagerRegistry.registerService(serviceName, serviceFactory, classLoader);
    }

    public void unregisterService(ServiceName serviceName) throws ServiceNotFoundException, ServiceRegistrationException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        this.unregisterService(serviceName, StopStrategies.SYNCHRONOUS);
    }

    public void unregisterService(ServiceName serviceName, StopStrategy stopStrategy) throws ServiceNotFoundException, ServiceRegistrationException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (stopStrategy == null) {
            throw new NullPointerException("stopStrategy is null");
        }
        if (!this.isRunning()) {
            return;
        }
        this.serviceManagerRegistry.unregisterService(serviceName, stopStrategy);
    }

    public boolean isRegistered(ServiceName serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (!this.isRunning()) {
            return false;
        }
        return this.serviceManagerRegistry.isRegistered(serviceName);
    }

    public ServiceState getServiceState(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        return serviceManager.getState();
    }

    public long getServiceStartTime(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        return serviceManager.getStartTime();
    }

    public void startService(ServiceName serviceName) throws ServiceNotFoundException, IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        this.startService(serviceName, false, StartStrategies.SYNCHRONOUS);
    }

    public void startService(ServiceName serviceName, StartStrategy startStrategy) throws ServiceNotFoundException, IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (startStrategy == null) {
            throw new NullPointerException("startStrategy is null");
        }
        this.startService(serviceName, false, startStrategy);
    }

    public void startServiceRecursive(ServiceName serviceName) throws ServiceNotFoundException, IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        this.startService(serviceName, true, StartStrategies.SYNCHRONOUS);
    }

    public void startServiceRecursive(ServiceName serviceName, StartStrategy startStrategy) throws ServiceNotFoundException, IllegalServiceStateException, UnsatisfiedConditionsException, Exception {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (startStrategy == null) {
            throw new NullPointerException("startStrategy is null");
        }
        this.startService(serviceName, true, startStrategy);
    }

    private void startService(ServiceName serviceName, boolean recursive, StartStrategy startStrategy) throws Exception {
        if (startStrategy == null) {
            throw new NullPointerException("startStrategy is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        try {
            serviceManager.start(recursive, startStrategy);
        }
        catch (UnregisterServiceException e) {
            try {
                this.unregisterService(serviceName, StopStrategies.FORCE);
            }
            catch (ServiceNotFoundException ignored) {
            }
            catch (ServiceRegistrationException ignored) {
                // empty catch block
            }
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    public void stopService(ServiceName serviceName) throws ServiceNotFoundException, UnsatisfiedConditionsException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        this.stopService(serviceName, StopStrategies.SYNCHRONOUS);
    }

    public void stopService(ServiceName serviceName, StopStrategy stopStrategy) throws ServiceNotFoundException, UnsatisfiedConditionsException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (stopStrategy == null) {
            throw new NullPointerException("stopStrategy is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        serviceManager.stop(stopStrategy);
    }

    public boolean isServiceEnabled(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        ServiceFactory serviceFactory = serviceManager.getServiceFactory();
        return serviceFactory.isEnabled();
    }

    public void setServiceEnabled(ServiceName serviceName, boolean enabled) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        ServiceFactory serviceFactory = serviceManager.getServiceFactory();
        serviceFactory.setEnabled(enabled);
    }

    public Object getService(ServiceName serviceName) throws ServiceNotFoundException, IllegalArgumentException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        return serviceManager.getService();
    }

    public Object getService(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!this.isRunning()) {
            return null;
        }
        Object service = this.serviceManagerRegistry.getService(type);
        return service;
    }

    public List getServices(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!this.isRunning()) {
            return null;
        }
        List services = this.serviceManagerRegistry.getServices(type);
        return services;
    }

    public ServiceFactory getServiceFactory(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        return serviceManager.getServiceFactory();
    }

    public ServiceFactory getServiceFactory(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!this.isRunning()) {
            return null;
        }
        ServiceManager serviceManager = this.serviceManagerRegistry.getServiceManager(type);
        return serviceManager.getServiceFactory();
    }

    public List getServiceFactories(Class type) {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (!this.isRunning()) {
            return null;
        }
        List serviceManagers = this.serviceManagerRegistry.getServiceManagers(type);
        ArrayList<ServiceFactory> serviceFactories = new ArrayList<ServiceFactory>(serviceManagers.size());
        Iterator iterator = serviceManagers.iterator();
        while (iterator.hasNext()) {
            ServiceManager serviceManager = (ServiceManager)iterator.next();
            serviceFactories.add(serviceManager.getServiceFactory());
        }
        return serviceFactories;
    }

    public ClassLoader getClassLoaderFor(ServiceName serviceName) throws ServiceNotFoundException {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        ServiceManager serviceManager = this.getServiceManager(serviceName);
        return serviceManager.getClassLoader();
    }

    private ServiceManager getServiceManager(ServiceName serviceName) throws ServiceNotFoundException {
        if (!this.isRunning()) {
            throw new ServiceNotFoundException(serviceName);
        }
        ServiceManager serviceManager = this.serviceManagerRegistry.getServiceManager(serviceName);
        return serviceManager;
    }

    public void addKernelMonitor(KernelMonitor kernelMonitor) {
        if (kernelMonitor == null) {
            throw new NullPointerException("kernelMonitor is null");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Kernel is stopped");
        }
        this.kernelMonitor.addKernelMonitor(kernelMonitor);
    }

    public void removeKernelMonitor(KernelMonitor kernelMonitor) {
        if (kernelMonitor == null) {
            throw new NullPointerException("kernelMonitor is null");
        }
        this.kernelMonitor.removeKernelMonitor(kernelMonitor);
    }

    public void addServiceMonitor(ServiceMonitor serviceMonitor) {
        if (serviceMonitor == null) {
            throw new NullPointerException("serviceMonitor is null");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Kernel is stopped");
        }
        this.addServiceMonitor(serviceMonitor, null);
    }

    public void addServiceMonitor(ServiceMonitor serviceMonitor, ServiceName serviceName) {
        if (serviceMonitor == null) {
            throw new NullPointerException("serviceMonitor is null");
        }
        if (serviceName == null) {
            throw new NullPointerException("serviceName is null");
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Kernel is stopped");
        }
        this.serviceMonitor.addServiceMonitor(serviceMonitor, serviceName);
    }

    public void removeServiceMonitor(ServiceMonitor serviceMonitor) {
        if (serviceMonitor == null) {
            throw new NullPointerException("serviceMonitor is null");
        }
        this.serviceMonitor.removeServiceMonitor(serviceMonitor);
    }
}

