/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.client;

import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.client.Destination;
import org.apache.servicemix.client.Message;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.resolver.URIResolver;
import org.w3c.dom.DocumentFragment;

public class DefaultDestination
implements Destination {
    private ServiceMixClient client;
    private ServiceEndpoint endpoint;
    private String destinationUri;

    public static ServiceEndpoint resolveEndpoint(ServiceMixClient client, String destinationUri) throws MessagingException {
        DocumentFragment epr = URIResolver.createWSAEPR(destinationUri);
        ServiceEndpoint endpoint = client.getContext().resolveEndpointReference(epr);
        if (endpoint == null) {
            throw new MessagingException("Could not resolve uri '" + destinationUri + "' into a ServiceEndpoint");
        }
        return endpoint;
    }

    public DefaultDestination(ServiceMixClient client, String destinationUri) throws MessagingException {
        this.client = client;
        this.destinationUri = destinationUri;
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        InOnly answer = this.client.createInOnlyExchange();
        this.configure((MessageExchange)answer);
        return answer;
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        InOptionalOut answer = this.client.createInOptionalOutExchange();
        this.configure((MessageExchange)answer);
        return answer;
    }

    public InOut createInOutExchange() throws MessagingException {
        InOut answer = this.client.createInOutExchange();
        this.configure((MessageExchange)answer);
        return answer;
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        RobustInOnly answer = this.client.createRobustInOnlyExchange();
        this.configure((MessageExchange)answer);
        return answer;
    }

    public Message createInOnlyMessage() throws MessagingException {
        return (Message)this.createInOnlyExchange().getInMessage();
    }

    protected void configure(MessageExchange exchange) throws MessagingException {
        if (this.endpoint == null) {
            this.endpoint = DefaultDestination.resolveEndpoint(this.client, this.destinationUri);
        }
        exchange.setEndpoint(this.endpoint);
    }
}

