/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import javax.jbi.component.Component;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.components.util.CopyTransformer;
import org.apache.servicemix.components.util.MessageTransformer;
import org.apache.servicemix.components.util.PojoSupport;
import org.apache.servicemix.components.util.ServiceUnitManagerSupport;
import org.apache.servicemix.jbi.NoInMessageAvailableException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class ComponentSupport
extends PojoSupport
implements Component {
    private ComponentLifeCycle lifeCycle;
    private ServiceUnitManager serviceManager;
    private MessageTransformer messageTransformer = CopyTransformer.getInstance();

    protected ComponentSupport() {
    }

    protected ComponentSupport(QName service, String endpoint) {
        super(service, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentLifeCycle getLifeCycle() {
        ComponentSupport componentSupport = this;
        synchronized (componentSupport) {
            if (this.lifeCycle == null) {
                this.lifeCycle = this.createComponentLifeCycle();
            }
        }
        return this.lifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        this.initializeServiceUnitManager();
        return this.serviceManager;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment fragment) {
        return null;
    }

    public Document getServiceDescription(ServiceEndpoint endpoint) {
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint endpoint, MessageExchange exchange) {
        return true;
    }

    protected synchronized void initializeServiceUnitManager() {
        if (this.serviceManager == null) {
            this.serviceManager = this.createServiceUnitManager();
        }
    }

    protected ServiceUnitManager createServiceUnitManager() {
        return new ServiceUnitManagerSupport();
    }

    protected ComponentLifeCycle createComponentLifeCycle() {
        return this;
    }

    protected NormalizedMessage getInMessage(MessageExchange exchange) throws NoInMessageAvailableException {
        NormalizedMessage message = exchange.getMessage("in");
        if (message == null) {
            throw new NoInMessageAvailableException(exchange);
        }
        return message;
    }

    public MessageTransformer getMessageTransformer() {
        return this.messageTransformer;
    }

    public void setMessageTransformer(MessageTransformer transformer) {
        this.messageTransformer = transformer;
    }

    public void invoke(MessageExchange exchange, NormalizedMessage in, QName service, QName interfaceName, QName operation) throws MessagingException {
        InOnly outExchange = this.createInOnlyExchange(service, interfaceName, operation);
        this.forwardToExchange(exchange, outExchange, in, operation);
    }

    public InOnly createInOnlyExchange(QName service, QName interfaceName, QName operation) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = null;
        factory = service != null ? channel.createExchangeFactoryForService(service) : (interfaceName != null ? channel.createExchangeFactory(interfaceName) : this.getExchangeFactory());
        InOnly outExchange = factory.createInOnlyExchange();
        if (service != null) {
            outExchange.setService(service);
        }
        if (interfaceName != null) {
            outExchange.setInterfaceName(interfaceName);
        }
        if (operation != null) {
            outExchange.setOperation(operation);
        }
        return outExchange;
    }

    public InOut createInOutExchange(QName service, QName interfaceName, QName operation) throws MessagingException {
        DeliveryChannel channel = this.getDeliveryChannel();
        MessageExchangeFactory factory = null;
        factory = service != null ? channel.createExchangeFactoryForService(service) : (interfaceName != null ? channel.createExchangeFactory(interfaceName) : this.getExchangeFactory());
        InOut outExchange = factory.createInOutExchange();
        if (service != null) {
            outExchange.setService(service);
        }
        if (interfaceName != null) {
            outExchange.setInterfaceName(interfaceName);
        }
        if (operation != null) {
            outExchange.setOperation(operation);
        }
        return outExchange;
    }

    protected void forwardToExchange(MessageExchange exchange, InOnly outExchange, NormalizedMessage in, QName operationName) throws MessagingException {
        if (operationName != null) {
            exchange.setOperation(operationName);
        }
        this.forwardToExchange(exchange, outExchange, in);
    }

    protected void forwardToExchange(MessageExchange exchange, InOnly outExchange, NormalizedMessage in) throws MessagingException {
        NormalizedMessage out = outExchange.createMessage();
        outExchange.setInMessage(out);
        this.getMessageTransformer().transform(exchange, in, out);
        this.getDeliveryChannel().send((MessageExchange)outExchange);
    }
}

