/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.components.util;

import java.io.IOException;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.components.util.MessageTransformer;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.ResourceSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.xml.sax.SAXException;

public class CopyTransformer
implements MessageTransformer {
    private static final CopyTransformer instance = new CopyTransformer();
    private SourceTransformer sourceTransformer = new SourceTransformer();
    private boolean copyProperties = true;
    private boolean copyAttachments = true;

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public static CopyTransformer getInstance() {
        return instance;
    }

    public boolean transform(MessageExchange exchange, NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        Source content;
        if (this.copyProperties) {
            CopyTransformer.copyProperties(from, to);
        }
        if (!(!((content = from.getContent()) instanceof StreamSource) && !(content instanceof SAXSource) || content instanceof StringSource || content instanceof BytesSource || content instanceof ResourceSource)) {
            try {
                content = this.sourceTransformer.toDOMSource(from);
            }
            catch (TransformerException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (IOException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (SAXException e) {
                throw new MessagingException((Throwable)e);
            }
        }
        to.setContent(content);
        if (this.copyAttachments) {
            CopyTransformer.copyAttachments(from, to);
        }
        return true;
    }

    public static void copyProperties(NormalizedMessage from, NormalizedMessage to) {
        Iterator iter = from.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = from.getProperty(name);
            to.setProperty(name, value);
        }
    }

    public static void copyAttachments(NormalizedMessage from, NormalizedMessage to) throws MessagingException {
        Iterator iter = from.getAttachmentNames().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DataHandler value = from.getAttachment(name);
            to.addAttachment(name, value);
        }
    }
}

