/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.audit.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.servicemix.jbi.audit.lucene.LuceneCallback;

public class DefaultLuceneCallback
implements LuceneCallback {
    private String field;
    private String query;

    public DefaultLuceneCallback(String field, String query) {
        this.field = field;
        this.query = query;
    }

    public Object doCallback(IndexSearcher is) throws IOException {
        try {
            Query queryObj = QueryParser.parse((String)this.query, (String)this.field, (Analyzer)new StandardAnalyzer());
            Hits hits = is.search(queryObj);
            int total = hits.length();
            String[] ids = new String[total];
            for (int i = 0; i < total; ++i) {
                Document d = hits.doc(i);
                ids[i] = d.get("org.apache.servicemix.exchangeid");
            }
            return ids;
        }
        catch (ParseException pe) {
            return new String[0];
        }
    }
}

