/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.QNameElementProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Element;

public class SubscriptionElementProcessor
extends QNameElementProcessor
implements ElementProcessor {
    private static final Log log = LogFactory.getLog((Class)SubscriptionElementProcessor.class);

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        String endpoint;
        String operation;
        String interfaceName;
        Element root = (Element)element.getParentNode();
        Element registration = this.addBeanElement(root, "org.apache.servicemix.jbi.container.SubscriptionSpec");
        String service = element.getAttribute("service");
        if (service != null) {
            element.removeAttribute("service");
            this.addQNameProperty(registration, "service", service, element);
        }
        if ((interfaceName = element.getAttribute("interface")) != null) {
            element.removeAttribute("interface");
            this.addQNameProperty(registration, "interfaceName", interfaceName, element);
        }
        if ((operation = element.getAttribute("operation")) != null) {
            element.removeAttribute("operation");
            this.addQNameProperty(registration, "operation", operation, element);
        }
        if ((endpoint = element.getAttribute("endpoint")) != null) {
            element.removeAttribute("endpoint");
            if (endpoint.length() > 0) {
                this.addPropertyElement(registration, "endpoint", endpoint);
            }
        }
        DOMUtil.copyAttributes(element, registration);
        DOMUtil.moveContent(element, registration);
        root.removeChild(element);
        this.logXmlGenerated(log, "subscription generated", registration);
    }
}

