/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicemix.jbi.config.spring.BeanElementProcessor;
import org.apache.servicemix.jbi.config.spring.BeanPropertyElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementToPropertyProcessor;
import org.apache.servicemix.jbi.config.spring.ElementToValueProcessor;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Element;

public abstract class CompositeElementProcessor
implements ElementProcessor {
    private String namespaceURI;
    private Map localNameToProcessor;
    private ElementProcessor defaultProcessor;

    public CompositeElementProcessor() {
        this("");
    }

    public CompositeElementProcessor(String namespaceURI) {
        this(namespaceURI, new ElementToPropertyProcessor());
    }

    protected CompositeElementProcessor(String namespaceURI, ElementProcessor defaultProcessor) {
        this.namespaceURI = namespaceURI;
        this.defaultProcessor = defaultProcessor;
        this.localNameToProcessor = new HashMap();
        this.loadLocalNameToProcessorMap();
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        String uri = element.getNamespaceURI();
        if (this.sameNamespace(uri, this.namespaceURI)) {
            String localName = element.getLocalName();
            ElementProcessor processor = (ElementProcessor)this.localNameToProcessor.get(localName);
            if (processor == null) {
                processor = this.defaultProcessor;
            }
            if (processor != null) {
                processor.processElement(element, beanDefinitionReader);
            }
        }
    }

    protected abstract void loadLocalNameToProcessorMap();

    protected boolean sameNamespace(String uri, String uri2) {
        return uri == uri2 || uri != null && uri.equals(uri2) || uri == null && uri2.length() == 0;
    }

    protected void registerProcessor(String localName, ElementProcessor processor) {
        this.localNameToProcessor.put(localName, processor);
    }

    protected ElementToPropertyProcessor registerPropertyAlias(String elementName, String propertyName) {
        ElementToPropertyProcessor processor = new ElementToPropertyProcessor(propertyName);
        this.registerProcessor(elementName, processor);
        return processor;
    }

    protected ElementToValueProcessor registerValueAlias(String elementName) {
        ElementToValueProcessor processor = new ElementToValueProcessor();
        this.registerProcessor(elementName, processor);
        return processor;
    }

    protected BeanElementProcessor registerBeanProcessor(String elementName, Class beanType) {
        return this.registerBeanProcessor(elementName, beanType, null);
    }

    protected BeanElementProcessor registerBeanProcessor(String elementName, Class beanType, String textPropertyName) {
        BeanElementProcessor processor = new BeanElementProcessor(beanType.getName(), textPropertyName, this);
        this.registerProcessor(elementName, processor);
        return processor;
    }

    protected BeanPropertyElementProcessor registerBeanPropertyProcessor(String elementName, Class type, String propertyName) {
        BeanPropertyElementProcessor processor = new BeanPropertyElementProcessor(type, propertyName, (ElementProcessor)this);
        this.registerProcessor(elementName, processor);
        return processor;
    }

    protected BeanPropertyElementProcessor registerBeanPropertyProcessor(String elementName, Class type) {
        return this.registerBeanPropertyProcessor(elementName, type, null);
    }
}

