/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementProcessorSupport {
    public static final String NAMESPACE = "";

    protected void processChildren(ElementProcessor processor, Element element, BeanDefinitionReader beanDefinitionReader) {
        for (Node current = element.getFirstChild(); current != null; current = current.getNextSibling()) {
            Node node = current;
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            processor.processElement(child, beanDefinitionReader);
            this.processChildren(processor, child, beanDefinitionReader);
        }
    }

    protected Element addElement(Node owner, String name) {
        Element property = owner.getOwnerDocument().createElementNS(NAMESPACE, name);
        owner.appendChild(property);
        return property;
    }

    protected Element addBeanElement(Node owner, String className) {
        Element bean = this.addElement(owner, "bean");
        bean.setAttribute("class", className);
        return bean;
    }

    protected Element addPropertyElement(Node bean, String propertyName) {
        Element property = this.addElement(bean, "property");
        property.setAttribute("name", this.convertToCamelCase(propertyName));
        return property;
    }

    protected Element addPropertyElement(Node bean, String propertyName, String value) {
        Element property = this.addPropertyElement(bean, propertyName);
        if (value != null) {
            property.setAttribute("value", value);
        }
        return property;
    }

    protected void addConstructorValueNode(Node bean, String value) {
        Element constructorArg = this.addElement(bean, "constructor-arg");
        constructorArg.setAttribute("value", value);
        bean.appendChild(constructorArg);
    }

    protected void logXmlGenerated(Log log, String message, Node node) {
        if (log.isDebugEnabled()) {
            try {
                String xml = DOMUtil.asXML(node);
                log.debug((Object)(message + ": " + xml));
            }
            catch (TransformerException e) {
                log.warn((Object)("Could not transform generated XML into text: " + e), (Throwable)e);
            }
        }
    }

    protected String getElementNameToPropertyName(Element element) {
        String name = element.getNodeName();
        return this.convertToCamelCase(name);
    }

    protected String convertToCamelCase(String name) {
        int idx;
        while ((idx = name.indexOf(45)) >= 0) {
            String prefix = name.substring(0, idx);
            String cap = name.substring(idx + 1, idx + 2);
            String rest = name.substring(idx + 2);
            name = prefix + cap.toUpperCase() + rest;
        }
        return name;
    }
}

