/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.config.spring;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessorSupport;
import org.apache.servicemix.jbi.util.DOMUtil;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.w3c.dom.Element;

public class QNameElementProcessor
extends ElementProcessorSupport
implements ElementProcessor {
    private static final transient Log log = LogFactory.getLog((Class)QNameElementProcessor.class);

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        Element root = (Element)element.getParentNode();
        QName qname = DOMUtil.createQName(element, DOMUtil.getElementText(element));
        Element bean = this.addQNameBeanElement(root, qname);
        root.removeChild(element);
        this.logXmlGenerated(log, "qname generated", bean);
    }

    protected Element addQNameBeanElement(Element owner, QName qname) {
        String prefix;
        boolean hasURI;
        Element bean = this.addBeanElement(owner, "javax.xml.namespace.QName");
        String uri = qname.getNamespaceURI();
        boolean bl = hasURI = uri != null && uri.length() > 0;
        if (hasURI) {
            this.addConstructorValueNode(bean, uri);
        }
        this.addConstructorValueNode(bean, qname.getLocalPart());
        if (hasURI && (prefix = qname.getPrefix()) != null && prefix.length() > 0) {
            this.addConstructorValueNode(bean, prefix);
        }
        return bean;
    }

    protected void addQNameProperty(Element registration, String propertyName, String qnameText, Element namespaceContext) {
        if (qnameText != null && qnameText.length() > 0) {
            Element property = this.addPropertyElement(registration, propertyName);
            QName qname = DOMUtil.createQName(namespaceContext, qnameText);
            this.addQNameBeanElement(property, qname);
        }
    }
}

