/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.deployment.impl;

import java.util.HashMap;
import org.apache.servicemix.jbi.config.spring.BeanPropertyElementProcessor;
import org.apache.servicemix.jbi.config.spring.ElementProcessor;
import org.apache.servicemix.jbi.deployment.Component;
import org.apache.servicemix.jbi.deployment.InstallationDescriptorExtension;
import org.apache.servicemix.jbi.deployment.impl.JbiNamespaceProcessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentElementProcessor
extends BeanPropertyElementProcessor {
    public static final String JBI_NAMESPACE = "";
    private JbiNamespaceProcessor jbiProcessor;

    public ComponentElementProcessor(JbiNamespaceProcessor childProcessor) {
        super(Component.class, null, (ElementProcessor)childProcessor);
        this.jbiProcessor = childProcessor;
    }

    public void processElement(Element element, BeanDefinitionReader beanDefinitionReader) {
        Element property = this.addPropertyElement(element, "sharedLibraries");
        Element list = this.addElement(property, "list");
        Node fragment = null;
        Node current = element.getFirstChild();
        while (current != null) {
            Node node = current;
            current = current.getNextSibling();
            if (node.getNodeType() != 1) continue;
            String uri = node.getNamespaceURI();
            if (!"http://java.sun.com/xml/ns/jbi".equals(uri) && node != property) {
                element.removeChild(node);
                if (fragment == null) {
                    fragment = element.getOwnerDocument().createDocumentFragment();
                }
                fragment.appendChild(node);
                continue;
            }
            if (!"shared-library".equals(node.getNodeName())) continue;
            Element child = (Element)node;
            element.removeChild(child);
            list.appendChild(child);
            this.jbiProcessor.getSharedListProcessor().processElement(child, beanDefinitionReader);
        }
        if (fragment != null) {
            Element descriptorProperty = this.addPropertyElement(element, "descriptorExtension");
            descriptorProperty.setAttribute("ref", "installationDescriptorExtension");
            HashMap<String, Node> propertiesMap = new HashMap<String, Node>();
            propertiesMap.put("descriptorExtension", fragment);
            RootBeanDefinition definition = new RootBeanDefinition(InstallationDescriptorExtension.class, new MutablePropertyValues(propertiesMap));
            beanDefinitionReader.getBeanFactory().registerBeanDefinition("installationDescriptorExtension", (BeanDefinition)definition);
        }
        super.processElement(element, beanDefinitionReader);
    }
}

