/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import org.apache.servicemix.jbi.framework.AdminCommandsServiceMBean;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.ManagementSupport;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.framework.ServiceUnitLifeCycle;
import org.apache.servicemix.jbi.framework.SharedLibrary;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;

public class AdminCommandsService
extends BaseSystemService
implements AdminCommandsServiceMBean {
    public String getDescription() {
        return "Admin Commands Service";
    }

    protected Class getServiceMBean() {
        return AdminCommandsServiceMBean.class;
    }

    public String installComponent(String file) throws Exception {
        return this.installComponent(file, null);
    }

    public String installComponent(String file, Properties props) throws Exception {
        try {
            this.container.getInstallationService().install(file, props, false);
            return ManagementSupport.createSuccessMessage("installComponent", file);
        }
        catch (Exception e) {
            throw ManagementSupport.failure("installComponent", file, e);
        }
    }

    public String uninstallComponent(String name) throws Exception {
        ComponentMBeanImpl comp = this.container.getComponent(name);
        if (comp == null) {
            throw ManagementSupport.failure("uninstallComponent", "Component '" + name + "' is not installed.");
        }
        if (!comp.isShutDown()) {
            throw ManagementSupport.failure("uninstallComponent", "Component '" + name + "' is not shut down.");
        }
        boolean success = this.container.getInstallationService().unloadInstaller(name, true);
        if (success) {
            return this.success("uninstallComponent", name);
        }
        return this.failure("uninstallComponent", name, null);
    }

    public String installSharedLibrary(String file) throws Exception {
        return this.container.getInstallationService().installSharedLibrary(file);
    }

    public String uninstallSharedLibrary(String name) throws Exception {
        SharedLibrary sl = this.container.getRegistry().getSharedLibrary(name);
        if (sl == null) {
            throw ManagementSupport.failure("uninstallSharedLibrary", "Shared library '" + name + "' is not installed.");
        }
        Collection components = this.container.getRegistry().getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            String[] sls;
            ComponentMBeanImpl comp = (ComponentMBeanImpl)iter.next();
            if (comp.isShutDown() || (sls = comp.getSharedLibraries()) == null) continue;
            for (int i = 0; i < sls.length; ++i) {
                if (!name.equals(sls[i])) continue;
                throw ManagementSupport.failure("uninstallSharedLibrary", "Shared library '" + name + "' is used by component '" + comp.getName() + "'.");
            }
        }
        boolean success = this.container.getInstallationService().uninstallSharedLibrary(name);
        if (success) {
            return this.success("uninstallSharedLibrary", name);
        }
        return this.failure("uninstallSharedLibrary", name, null);
    }

    public String startComponent(String name) throws Exception {
        try {
            ComponentMBeanImpl lcc = this.container.getComponent(name);
            if (lcc == null) {
                throw new JBIException("Component " + name + " not found");
            }
            lcc.start();
            return this.success("startComponent", name);
        }
        catch (JBIException e) {
            throw new RuntimeException(this.failure("startComponent", name, (Exception)((Object)e)));
        }
    }

    public String stopComponent(String name) throws Exception {
        try {
            ComponentMBeanImpl lcc = this.container.getComponent(name);
            if (lcc == null) {
                throw new JBIException("Component " + name + " not found");
            }
            lcc.stop();
            return this.success("stopComponent", name);
        }
        catch (JBIException e) {
            throw new RuntimeException(this.failure("stopComponent", name, (Exception)((Object)e)));
        }
    }

    public String shutdownComponent(String name) throws Exception {
        try {
            ComponentMBeanImpl lcc = this.container.getComponent(name);
            if (lcc == null) {
                throw new JBIException("Component " + name + " not found");
            }
            lcc.shutDown();
            return this.success("shutdownComponent", name);
        }
        catch (JBIException e) {
            throw new RuntimeException(this.failure("shutdownComponent", name, (Exception)((Object)e)));
        }
    }

    public String deployServiceAssembly(String file) throws Exception {
        return this.container.getDeploymentService().deploy(file);
    }

    public String undeployServiceAssembly(String name) throws Exception {
        return this.container.getDeploymentService().undeploy(name);
    }

    public String startServiceAssembly(String name) throws Exception {
        return this.container.getDeploymentService().start(name);
    }

    public String stopServiceAssembly(String name) throws Exception {
        return this.container.getDeploymentService().stop(name);
    }

    public String shutdownServiceAssembly(String name) throws Exception {
        return this.container.getDeploymentService().shutDown(name);
    }

    public String installArchive(String location) throws Exception {
        try {
            this.container.updateExternalArchive(location);
            return this.success("installArchive", location);
        }
        catch (Exception e) {
            throw new RuntimeException(this.failure("shutdownServiceAssembly", location, e));
        }
    }

    public String listComponents(boolean excludeSEs, boolean excludeBCs, boolean excludePojos, String requiredState, String sharedLibraryName, String serviceAssemblyName) throws Exception {
        if (!(requiredState == null || requiredState.length() <= 0 || "Unknown".equalsIgnoreCase(requiredState) || "Shutdown".equalsIgnoreCase(requiredState) || "Stopped".equalsIgnoreCase(requiredState) || "Started".equalsIgnoreCase(requiredState))) {
            throw ManagementSupport.failure("listComponents", "Required state '" + requiredState + "' is not a valid state.");
        }
        Collection connectors = this.container.getRegistry().getComponents();
        ArrayList<ComponentMBeanImpl> components = new ArrayList<ComponentMBeanImpl>();
        Iterator iter = connectors.iterator();
        while (iter.hasNext()) {
            ComponentMBeanImpl component = (ComponentMBeanImpl)iter.next();
            if (excludeSEs && component.isService() || excludeBCs && component.isBinding() || excludePojos && component.isPojo() || requiredState != null && requiredState.length() > 0 && !requiredState.equalsIgnoreCase(component.getCurrentState()) || sharedLibraryName != null && sharedLibraryName.length() > 0 && !this.container.getInstallationService().containsSharedLibrary(sharedLibraryName)) continue;
            if (serviceAssemblyName != null && serviceAssemblyName.length() > 0) {
                String[] saNames = this.container.getRegistry().getDeployedServiceAssembliesForComponent(component.getName());
                boolean found = false;
                for (int i = 0; i < saNames.length; ++i) {
                    if (!serviceAssemblyName.equals(saNames[i])) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            components.add(component);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<component-info-list xmlns='http://java.sun.com/xml/ns/jbi/component-info-list' version='1.0'>\n");
        Iterator iter2 = components.iterator();
        while (iter2.hasNext()) {
            ComponentMBeanImpl component = (ComponentMBeanImpl)iter2.next();
            buffer.append("  <component-info");
            if (!component.isBinding() && component.isService()) {
                buffer.append(" type='service-engine'");
            } else if (component.isBinding() && !component.isService()) {
                buffer.append(" type='binding-component'");
            }
            buffer.append(" name='" + component.getName() + "'");
            buffer.append(" state='" + component.getCurrentState() + "'>\n");
            if (component.getDescription() != null) {
                buffer.append("    <description>");
                buffer.append(component.getDescription());
                buffer.append("</description>\n");
            }
            buffer.append("  </component-info>\n");
        }
        buffer.append("</component-info-list>");
        return buffer.toString();
    }

    public String listSharedLibraries(String componentName, String sharedLibraryName) throws Exception {
        SharedLibrary sl;
        Collection<Object> libs = sharedLibraryName != null ? ((sl = this.container.getRegistry().getSharedLibrary(sharedLibraryName)) == null ? Collections.EMPTY_LIST : Collections.singletonList(sl)) : (componentName != null ? this.container.getRegistry().getSharedLibraries() : this.container.getRegistry().getSharedLibraries());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<component-info-list xmlns='http://java.sun.com/xml/ns/jbi/component-info-list' version='1.0'>\n");
        Iterator iter = libs.iterator();
        while (iter.hasNext()) {
            SharedLibrary sl2 = (SharedLibrary)iter.next();
            buffer.append("  <component-info type='shared-library' name='").append(sl2.getName()).append("' state='Started'>");
            if (sl2.getDescription() != null) {
                buffer.append("    <description>");
                buffer.append(sl2.getDescription());
                buffer.append("</description>\n");
            }
            buffer.append("  </component-info>\n");
        }
        buffer.append("</component-info-list>");
        return buffer.toString();
    }

    public String listServiceAssemblies(String state, String componentName, String serviceAssemblyName) throws Exception {
        String[] result = null;
        result = null != serviceAssemblyName && serviceAssemblyName.length() > 0 ? new String[]{serviceAssemblyName} : (null != componentName && componentName.length() > 0 ? this.container.getRegistry().getDeployedServiceAssembliesForComponent(componentName) : this.container.getRegistry().getDeployedServiceAssemblies());
        ArrayList<ServiceAssemblyLifeCycle> assemblies = new ArrayList<ServiceAssemblyLifeCycle>();
        for (int i = 0; i < result.length; ++i) {
            ServiceAssemblyLifeCycle sa = this.container.getRegistry().getServiceAssembly(result[i]);
            if (sa == null || state != null && state.length() > 0 && !state.equals(sa.getCurrentState())) continue;
            assemblies.add(sa);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<service-assembly-info-list xmlns='http://java.sun.com/xml/ns/jbi/service-assembly-info-list' version='1.0'>\n");
        Iterator iter = assemblies.iterator();
        while (iter.hasNext()) {
            ServiceAssemblyLifeCycle sa = (ServiceAssemblyLifeCycle)iter.next();
            buffer.append("  <service-assembly-info");
            buffer.append(" name='" + sa.getName() + "'");
            buffer.append(" state='" + sa.getCurrentState() + "'>\n");
            buffer.append("    <description>" + sa.getDescription() + "</description>\n");
            ServiceUnitLifeCycle[] serviceUnitList = sa.getDeployedSUs();
            for (int i = 0; i < serviceUnitList.length; ++i) {
                buffer.append("    <service-unit-info");
                buffer.append(" name='" + serviceUnitList[i].getName() + "'");
                buffer.append(" state='" + serviceUnitList[i].getCurrentState() + "'");
                buffer.append(" deployed-on='" + serviceUnitList[i].getComponentName() + "'>\n");
                buffer.append("      <description>" + serviceUnitList[i].getDescription() + "</description>\n");
                buffer.append("    </service-unit-info>\n");
            }
            buffer.append("  </service-assembly-info>\n");
        }
        buffer.append("</service-assembly-info-list>");
        return buffer.toString();
    }

    public String failure(String task, String location, Exception e) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setTask(task);
        msg.setResult("FAILED");
        msg.setType("ERROR");
        msg.setException(e);
        msg.setMessage(location);
        return ManagementSupport.createFrameworkMessage(msg, null);
    }

    public String success(String task, String location) {
        ManagementSupport.Message msg = new ManagementSupport.Message();
        msg.setTask(task);
        msg.setMessage(location);
        msg.setResult("SUCCESS");
        return ManagementSupport.createFrameworkMessage(msg, null);
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "installComponent", 1, "install a component");
        ph.setDescription(0, "file", "location of JBI Component to install");
        ph = helper.addOperation(this.getObjectToManage(), "uninstallComponent", 1, "uninstall a component");
        ph.setDescription(0, "name", "component name to uninstall");
        ph = helper.addOperation(this.getObjectToManage(), "installSharedLibrary", 1, "install a shared library");
        ph.setDescription(0, "file", "location of shared library to install");
        ph = helper.addOperation(this.getObjectToManage(), "uninstallSharedLibrary", 1, "uninstall a shared library");
        ph.setDescription(0, "name", "name of shared library to uninstall");
        ph = helper.addOperation(this.getObjectToManage(), "installArchive", 1, "install an archive (component/SA etc)");
        ph.setDescription(0, "location", "file name or url to the location");
        ph = helper.addOperation(this.getObjectToManage(), "startComponent", 1, "start a component");
        ph.setDescription(0, "name", "name of component to start");
        ph = helper.addOperation(this.getObjectToManage(), "stopComponent", 1, "stop a component");
        ph.setDescription(0, "name", "name of component to stop");
        ph = helper.addOperation(this.getObjectToManage(), "shutdownComponent", 1, "shutdown a component");
        ph.setDescription(0, "name", "name of component to shutdown");
        ph = helper.addOperation(this.getObjectToManage(), "deployServiceAssembly", 1, "deploy a service assembly");
        ph.setDescription(0, "file", "location of service assembly to deploy");
        ph = helper.addOperation(this.getObjectToManage(), "undeployServiceAssembly", 1, "undeploy a service assembly");
        ph.setDescription(0, "name", "name of service assembly to undeploy");
        ph = helper.addOperation(this.getObjectToManage(), "startServiceAssembly", 1, "start a service assembly");
        ph.setDescription(0, "name", "name of service assembly to start");
        ph = helper.addOperation(this.getObjectToManage(), "stopServiceAssembly", 1, "stop a service assembly");
        ph.setDescription(0, "name", "name of service assembly to stop");
        ph = helper.addOperation(this.getObjectToManage(), "shutdownServiceAssembly", "shutdown a service assembly");
        ph.setDescription(0, "name", "name of service assembly to shutdown");
        ph = helper.addOperation(this.getObjectToManage(), "listComponents", 5, "list all components installed");
        ph.setDescription(0, "excludeSEs", "if true will exclude service engines");
        ph.setDescription(1, "excludeBCs", "if true will exclude binding components");
        ph.setDescription(1, "excludePojos", "if true will exclude pojos components");
        ph.setDescription(2, "requiredState", "component state to list, if null will list all");
        ph.setDescription(3, "sharedLibraryName", "shared library name to list");
        ph.setDescription(4, "serviceAssemblyName", "service assembly name to list");
        ph = helper.addOperation(this.getObjectToManage(), "listSharedLibraries", 2, "list shared library");
        ph.setDescription(0, "componentName", "component name");
        ph.setDescription(1, "sharedLibraryName", "shared library name");
        ph = helper.addOperation(this.getObjectToManage(), "listServiceAssemblies", 3, "list service assemblies");
        ph.setDescription(0, "state", "service assembly state to list");
        ph.setDescription(1, "componentName", "component name");
        ph.setDescription(2, "serviceAssemblyName", "service assembly name");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }
}

