/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ActivationSpec;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.framework.ComponentContextImpl;
import org.apache.servicemix.jbi.framework.ComponentMBean;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.framework.ComponentStats;
import org.apache.servicemix.jbi.framework.ComponentStatsMBean;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.framework.ServiceAssemblyLifeCycle;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.management.ManagementContext;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.messaging.DeliveryChannelImpl;
import org.apache.servicemix.jbi.messaging.MessagingStats;
import org.apache.servicemix.jbi.util.XmlPersistenceSupport;

public class ComponentMBeanImpl
extends BaseLifeCycle
implements ComponentMBean {
    private static Log log = LogFactory.getLog((Class)ComponentMBeanImpl.class);
    private boolean exchangeThrottling;
    private long throttlingTimeout = 100L;
    private int throttlingInterval = 1;
    private Component component;
    private ComponentLifeCycle lifeCycle;
    private ServiceUnitManager suManager;
    private ComponentContextImpl context;
    private ActivationSpec activationSpec;
    private ObjectName mBeanName;
    private ComponentStats componentStatsMBean;
    private ObjectName componentStatsMBeanName;
    private JBIContainer container;
    private MessagingStats messagingStats;
    private ComponentNameSpace componentName;
    private String description = "POJO Component";
    private boolean pojo;
    private boolean binding;
    private boolean service;
    private File stateFile;
    private String[] sharedLibraries;

    public ComponentMBeanImpl(JBIContainer container, ComponentNameSpace name, String description, Component component, boolean binding, boolean service, String[] sharedLibraries) {
        this.componentName = name;
        this.container = container;
        this.component = component;
        this.description = description;
        this.binding = binding;
        this.service = service;
        this.componentStatsMBean = new ComponentStats(this);
        this.messagingStats = new MessagingStats(name.getName());
        this.sharedLibraries = sharedLibraries;
    }

    public ObjectName registerMBeans(ManagementContext context) throws JBIException {
        try {
            this.mBeanName = context.createObjectName(this);
            context.registerMBean(this.mBeanName, this, ComponentMBean.class);
            this.componentStatsMBeanName = context.createObjectName(this.componentStatsMBean);
            context.registerMBean(this.componentStatsMBeanName, this.componentStatsMBean, ComponentStatsMBean.class);
            return this.mBeanName;
        }
        catch (Exception e) {
            String errorStr = "Failed to register MBeans";
            log.error((Object)errorStr, (Throwable)e);
            throw new JBIException(errorStr, (Throwable)e);
        }
    }

    public void unregisterMbeans(ManagementContext context) throws JBIException {
        context.unregisterMBean(this.mBeanName);
        context.unregisterMBean(this.componentStatsMBeanName);
    }

    public void setContext(ComponentContextImpl context) {
        this.context = context;
        this.stateFile = context.getEnvironment().getStateFile();
    }

    public ObjectName getExtensionMBeanName() {
        if (this.isInitialized() || this.isStarted() || this.isStopped()) {
            return this.lifeCycle.getExtensionMBeanName();
        }
        return null;
    }

    public String getName() {
        return this.componentName.getName();
    }

    public String getType() {
        return "Component";
    }

    public String getSubType() {
        return "LifeCycle";
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws JBIException {
        log.info((Object)("Initializing component: " + this.getName()));
        if (this.context != null && this.component != null) {
            DeliveryChannelImpl channel = new DeliveryChannelImpl(this);
            channel.setContext(this.context);
            this.context.setDeliveryChannel(channel);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getLifeCycle().getClass().getClassLoader());
                this.getLifeCycle().init((ComponentContext)this.context);
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
        super.init();
    }

    public void start() throws JBIException {
        log.info((Object)("Starting component: " + this.getName()));
        try {
            this.doStart();
            this.persistRunningState();
            this.getContainer().getRegistry().checkPendingAssemblies();
        }
        catch (JBIException e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
    }

    public void stop() throws JBIException {
        log.info((Object)("Stopping component: " + this.getName()));
        try {
            this.doStop();
            this.persistRunningState();
        }
        catch (JBIException e) {
            log.error((Object)"Could not stop component", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
    }

    public void shutDown() throws JBIException {
        log.info((Object)("Shutting down component: " + this.getName()));
        try {
            this.doShutDown();
            this.persistRunningState();
        }
        catch (JBIException e) {
            log.error((Object)"Could not shutDown component", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
        catch (Error e) {
            log.error((Object)"Could not start component", (Throwable)e);
            throw e;
        }
    }

    public void setShutdownStateAfterInstall() {
        this.setCurrentState("Shutdown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws JBIException {
        if (this.isShutDown()) {
            this.init();
        }
        if (!this.isStarted()) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getLifeCycle().getClass().getClassLoader());
                this.getLifeCycle().start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            super.start();
            this.initServiceAssemblies();
            this.startServiceAssemblies();
        }
        this.fireEvent(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws JBIException {
        if (this.isUnknown() || this.isStarted()) {
            this.stopServiceAssemblies();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getLifeCycle().getClass().getClassLoader());
                this.getLifeCycle().stop();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            super.stop();
        }
        this.fireEvent(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doShutDown() throws JBIException {
        if (!this.isUnknown() && !this.isShutDown()) {
            this.doStop();
            this.shutDownServiceAssemblies();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getLifeCycle().getClass().getClassLoader());
                this.getLifeCycle().shutDown();
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if (this.getDeliveryChannel() != null) {
                this.getDeliveryChannel().close();
                this.setDeliveryChannel(null);
            }
        }
        super.shutDown();
        this.fireEvent(3);
    }

    public void setInitialRunningState() throws JBIException {
        if (!this.isPojo()) {
            String componentName = this.getName();
            String runningState = this.getRunningStateFromStore();
            log.info((Object)("Setting running state for Component: " + componentName + " to " + runningState));
            if (runningState != null) {
                if (runningState.equals("Started")) {
                    this.doStart();
                } else if (runningState.equals("Stopped")) {
                    this.doStart();
                    this.doStop();
                } else if (runningState.equals("Shutdown")) {
                    this.doShutDown();
                }
            }
        }
    }

    public void persistRunningState() {
        if (!this.isPojo()) {
            String componentName = this.getName();
            try {
                String currentState = this.getCurrentState();
                Properties props = new Properties();
                props.setProperty("state", currentState);
                XmlPersistenceSupport.write(this.stateFile, props);
            }
            catch (IOException e) {
                log.error((Object)("Failed to write current running state for Component: " + componentName), (Throwable)e);
            }
        }
    }

    public String getRunningStateFromStore() {
        String result = "Unknown";
        String componentName = this.getName();
        try {
            Properties props = (Properties)XmlPersistenceSupport.read(this.stateFile);
            result = props.getProperty("state", result);
        }
        catch (Exception e) {
            log.error((Object)("Failed to read running state for Component: " + componentName), (Throwable)e);
        }
        return result;
    }

    public int getInboundQueueCapacity() {
        if (this.getDeliveryChannel() != null) {
            return this.getDeliveryChannel().getQueueCapacity();
        }
        return 0;
    }

    public void setInboundQueueCapacity(int value) {
        if (this.getDeliveryChannel() != null) {
            this.getDeliveryChannel().setQueueCapacity(value);
        }
    }

    public DeliveryChannelImpl getDeliveryChannel() {
        return (DeliveryChannelImpl)this.context.getDeliveryChannel();
    }

    public void setDeliveryChannel(DeliveryChannelImpl deliveryChannel) {
        this.context.setDeliveryChannel(deliveryChannel);
    }

    public ActivationSpec getActivationSpec() {
        return this.activationSpec;
    }

    public boolean isPojo() {
        return this.pojo;
    }

    public void setActivationSpec(ActivationSpec activationSpec) {
        this.activationSpec = activationSpec;
    }

    public boolean isExchangeThrottling() {
        return this.exchangeThrottling;
    }

    public void setExchangeThrottling(boolean value) {
        this.exchangeThrottling = value;
    }

    public long getThrottlingTimeout() {
        return this.throttlingTimeout;
    }

    public void setThrottlingTimeout(long value) {
        this.throttlingTimeout = value;
    }

    public int getThrottlingInterval() {
        return this.throttlingInterval;
    }

    public void setThrottlingInterval(int value) {
        this.throttlingInterval = value;
    }

    public ObjectName getStatsMBeanName() {
        return this.componentStatsMBeanName;
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "inboundQueueCapacity", "capacity of the inbound queue");
        helper.addAttribute(this.getObjectToManage(), "exchangeThrottling", "apply throttling");
        helper.addAttribute(this.getObjectToManage(), "throttlingTimeout", "timeout for throttling");
        helper.addAttribute(this.getObjectToManage(), "throttlingInterval", "exchange intervals before throttling");
        helper.addAttribute(this.getObjectToManage(), "extensionMBeanName", "extension mbean name");
        helper.addAttribute(this.getObjectToManage(), "statsMBeanName", "Statistics mbean name");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }

    public void firePropertyChanged(String name, Object oldValue, Object newValue) {
        super.firePropertyChanged(name, oldValue, newValue);
    }

    protected void initServiceAssemblies() throws DeploymentException {
    }

    protected void startServiceAssemblies() throws DeploymentException {
    }

    protected void stopServiceAssemblies() throws DeploymentException {
        Registry registry = this.getContainer().getRegistry();
        String[] sas = registry.getDeployedServiceAssembliesForComponent(this.getName());
        for (int i = 0; i < sas.length; ++i) {
            ServiceAssemblyLifeCycle sa = registry.getServiceAssembly(sas[i]);
            if (!sa.isStarted()) continue;
            try {
                sa.stop(false, false);
                registry.addPendingAssembly(sa);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error stopping service assembly " + sas[i]));
            }
        }
    }

    protected void shutDownServiceAssemblies() throws DeploymentException {
        Registry registry = this.getContainer().getRegistry();
        String[] sas = registry.getDeployedServiceAssembliesForComponent(this.getName());
        for (int i = 0; i < sas.length; ++i) {
            ServiceAssemblyLifeCycle sa = registry.getServiceAssembly(sas[i]);
            if (!sa.isStopped()) continue;
            try {
                sa.shutDown(false);
                registry.addPendingAssembly(sa);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error shutting down service assembly " + sas[i]));
            }
        }
    }

    protected void fireEvent(int type) {
        ComponentEvent event = new ComponentEvent(this, type);
        ComponentListener[] listeners = (ComponentListener[])this.getContainer().getListeners(ComponentListener.class);
        block5: for (int i = 0; i < listeners.length; ++i) {
            switch (type) {
                case 1: {
                    listeners[i].componentStarted(event);
                    continue block5;
                }
                case 2: {
                    listeners[i].componentStopped(event);
                    continue block5;
                }
                case 3: {
                    listeners[i].componentShutDown(event);
                }
            }
        }
    }

    public ComponentLifeCycle getLifeCycle() {
        if (this.lifeCycle == null) {
            this.lifeCycle = this.component.getLifeCycle();
        }
        return this.lifeCycle;
    }

    public ServiceUnitManager getServiceUnitManager() {
        if (this.suManager == null) {
            this.suManager = this.component.getServiceUnitManager();
        }
        return this.suManager;
    }

    public JBIContainer getContainer() {
        return this.container;
    }

    public MessagingStats getMessagingStats() {
        return this.messagingStats;
    }

    public Component getComponent() {
        return this.component;
    }

    public ComponentNameSpace getComponentNameSpace() {
        return this.componentName;
    }

    public ComponentContextImpl getContext() {
        return this.context;
    }

    public ObjectName getMBeanName() {
        return this.mBeanName;
    }

    public boolean isBinding() {
        return this.binding;
    }

    public boolean isService() {
        return this.service;
    }

    public void setPojo(boolean pojo) {
        this.pojo = pojo;
    }

    public boolean isEngine() {
        return this.service;
    }

    public String[] getSharedLibraries() {
        return this.sharedLibraries;
    }
}

