/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import java.beans.PropertyChangeListener;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.jbi.framework.EndpointMBean;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.servicedesc.AbstractServiceEndpoint;
import org.apache.servicemix.jbi.servicedesc.ExternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;
import org.apache.servicemix.jbi.servicedesc.LinkedEndpoint;
import org.apache.servicemix.jbi.util.DOMUtil;

public class Endpoint
implements EndpointMBean,
MBeanInfoProvider {
    private AbstractServiceEndpoint endpoint;
    private Registry registry;

    public Endpoint(AbstractServiceEndpoint endpoint, Registry registry) {
        this.endpoint = endpoint;
        this.registry = registry;
    }

    public String getEndpointName() {
        return this.endpoint.getEndpointName();
    }

    public QName[] getInterfaces() {
        return this.endpoint.getInterfaces();
    }

    public QName getServiceName() {
        return this.endpoint.getServiceName();
    }

    public String getReference() {
        try {
            return DOMUtil.asIndentedXML(this.endpoint.getAsReference(null));
        }
        catch (TransformerException e) {
            return null;
        }
    }

    public String getWSDL() {
        try {
            return DOMUtil.asXML(this.registry.getEndpointDescriptor(this.endpoint));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getComponentName() {
        if (this.endpoint.getComponentNameSpace() != null) {
            return this.endpoint.getComponentNameSpace().getName();
        }
        return null;
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "endpointName", "name of the endpoint");
        helper.addAttribute(this.getObjectToManage(), "serviceName", "name of the service");
        helper.addAttribute(this.getObjectToManage(), "componentName", "component name of the service unit");
        helper.addAttribute(this.getObjectToManage(), "interfaces", "interfaces implemented by this endpoint");
        return helper.getAttributeInfos();
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        helper.addOperation(this.getObjectToManage(), "getReference", "retrieve the endpoint reference");
        helper.addOperation(this.getObjectToManage(), "getWSDL", "retrieve the wsdl description of this endpoint");
        return helper.getOperationInfos();
    }

    public Object getObjectToManage() {
        return this;
    }

    public String getName() {
        return this.endpoint.getServiceName() + this.endpoint.getEndpointName();
    }

    public String getType() {
        return "Endpoint";
    }

    public String getSubType() {
        if (this.endpoint instanceof InternalEndpoint) {
            return "Internal";
        }
        if (this.endpoint instanceof LinkedEndpoint) {
            return "Linked";
        }
        if (this.endpoint instanceof ExternalEndpoint) {
            return "External";
        }
        return null;
    }

    public String getDescription() {
        return null;
    }

    public void setPropertyChangeListener(PropertyChangeListener l) {
    }

    protected AbstractServiceEndpoint getEndpoint() {
        return this.endpoint;
    }
}

