/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.framework;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.servicemix.jbi.container.SubscriptionSpec;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.servicedesc.InternalEndpoint;

public class SubscriptionRegistry {
    private Map subscriptions = new ConcurrentHashMap();
    private Registry registry;

    public SubscriptionRegistry(Registry registry) {
        this.registry = registry;
    }

    public void registerSubscription(SubscriptionSpec subscription, InternalEndpoint endpoint) {
        this.subscriptions.put(subscription, endpoint);
    }

    public InternalEndpoint deregisterSubscription(SubscriptionSpec subscription) {
        return (InternalEndpoint)this.subscriptions.remove(subscription);
    }

    public List getMatchingSubscriptionEndpoints(MessageExchangeImpl exchange) {
        ArrayList<InternalEndpoint> result = null;
        Iterator iter = this.subscriptions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            SubscriptionSpec subscription = (SubscriptionSpec)entry.getKey();
            if (!subscription.matches(this.registry, exchange)) continue;
            if (result == null) {
                result = new ArrayList<InternalEndpoint>();
            }
            InternalEndpoint endpoint = (InternalEndpoint)entry.getValue();
            result.add(endpoint);
        }
        return result;
    }
}

