/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.jaxp;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StaxSource;
import org.apache.servicemix.jbi.jaxp.W3CDOMStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class StAXSourceTransformer
extends SourceTransformer {
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;

    public StaxSource toStaxSource(Source source) throws XMLStreamException {
        if (source instanceof StaxSource) {
            return (StaxSource)source;
        }
        XMLInputFactory factory = this.getInputFactory();
        XMLStreamReader reader = factory.createXMLStreamReader(source);
        return new StaxSource(reader);
    }

    public XMLStreamReader toXMLStreamReader(Source source) throws XMLStreamException, TransformerException {
        if (source instanceof DOMSource) {
            Element el;
            Node n = ((DOMSource)source).getNode();
            Element element = n instanceof Document ? ((Document)n).getDocumentElement() : (el = n instanceof Element ? (Element)n : null);
            if (el != null) {
                return new W3CDOMStreamReader(el);
            }
        }
        XMLInputFactory factory = this.getInputFactory();
        try {
            return factory.createXMLStreamReader(source);
        }
        catch (XMLStreamException e) {
            return factory.createXMLStreamReader(this.toReaderFromSource(source));
        }
    }

    public DOMSource toDOMSource(Source source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        DOMSource answer = super.toDOMSource(source);
        if (answer == null && source instanceof StaxSource) {
            answer = this.toDOMSourceFromStax((StaxSource)source);
        }
        return answer;
    }

    public SAXSource toSAXSource(Source source) throws IOException, SAXException {
        SAXSource answer = super.toSAXSource(source);
        if (answer == null && source instanceof StaxSource) {
            answer = this.toSAXSourceFromStax((StaxSource)source);
        }
        return answer;
    }

    public DOMSource toDOMSourceFromStax(StaxSource source) throws TransformerException {
        Transformer transformer = this.createTransfomer();
        DOMResult result = new DOMResult();
        transformer.transform(source, result);
        return new DOMSource(result.getNode(), result.getSystemId());
    }

    public SAXSource toSAXSourceFromStax(StaxSource source) {
        return source;
    }

    public XMLInputFactory getInputFactory() {
        if (this.inputFactory == null) {
            this.inputFactory = this.createInputFactory();
        }
        return this.inputFactory;
    }

    public void setInputFactory(XMLInputFactory inputFactory) {
        this.inputFactory = inputFactory;
    }

    public XMLOutputFactory getOutputFactory() {
        if (this.outputFactory == null) {
            this.outputFactory = this.createOutputFactory();
        }
        return this.outputFactory;
    }

    public void setOutputFactory(XMLOutputFactory outputFactory) {
        this.outputFactory = outputFactory;
    }

    protected XMLInputFactory createInputFactory() {
        XMLInputFactory answer = XMLInputFactory.newInstance();
        return answer;
    }

    protected XMLOutputFactory createOutputFactory() {
        XMLOutputFactory answer = XMLOutputFactory.newInstance();
        return answer;
    }
}

