/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.loaders;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.servicemix.jbi.loaders.JarFileUrlConnection;

public class JarFileUrlStreamHandler
extends URLStreamHandler {
    private URL expectedUrl;
    private final JarFile jarFile;
    private final JarEntry jarEntry;

    public static URL createUrl(JarFile jarFile, JarEntry jarEntry) throws MalformedURLException {
        return JarFileUrlStreamHandler.createUrl(jarFile, jarEntry, new File(jarFile.getName()).toURL());
    }

    public static URL createUrl(JarFile jarFile, JarEntry jarEntry, URL codeSource) throws MalformedURLException {
        JarFileUrlStreamHandler handler = new JarFileUrlStreamHandler(jarFile, jarEntry);
        URL url = new URL("jar", "", -1, codeSource + "!/" + jarEntry.getName(), handler);
        handler.setExpectedUrl(url);
        return url;
    }

    public JarFileUrlStreamHandler(JarFile jarFile, JarEntry jarEntry) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile is null");
        }
        if (jarEntry == null) {
            throw new NullPointerException("jarEntry is null");
        }
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
    }

    public void setExpectedUrl(URL expectedUrl) {
        if (expectedUrl == null) {
            throw new NullPointerException("expectedUrl is null");
        }
        this.expectedUrl = expectedUrl;
    }

    public URLConnection openConnection(URL url) throws MalformedURLException {
        if (this.expectedUrl == null) {
            throw new IllegalStateException("expectedUrl was not set");
        }
        if (!this.expectedUrl.equals(url)) {
            throw new IllegalArgumentException("Expected url [" + this.expectedUrl + "], but was [" + url + "]");
        }
        return new JarFileUrlConnection(url, this.jarFile, this.jarEntry);
    }
}

