/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.loaders;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import org.apache.servicemix.jbi.loaders.ClassLoaderUtil;
import org.apache.servicemix.jbi.loaders.DestroyableClassLoader;

public class NamedClassLoader
extends URLClassLoader
implements DestroyableClassLoader {
    private final String name;
    private boolean destroyed = false;

    public NamedClassLoader(String name, URL[] urls) {
        super(urls);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
    }

    public NamedClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
        this.name = name;
    }

    public synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        NamedClassLoader namedClassLoader = this;
        synchronized (namedClassLoader) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        ClassLoaderUtil.destroy(this);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ":" + " name=" + this.getName() + " urls=" + Arrays.asList(this.getURLs()) + "]";
    }
}

