/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MBeanServerContext {
    public static final String DEFAULT_DOMAIN = "org.apache.activemq";
    private static final Log log = LogFactory.getLog((Class)ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = "org.apache.activemq";
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer = false;
    private boolean createConnector = true;
    private boolean findTigerMbeanServer = false;
    private int connectorPort = 1099;
    private String connectorPath = "/jmxrmi";
    private AtomicBoolean started = new AtomicBoolean(false);
    private JMXConnectorServer connectorServer;
    private ObjectName namingServiceObjectName;

    public MBeanServerContext() {
        this(null);
    }

    public MBeanServerContext(MBeanServer server) {
        this.beanServer = server;
    }

    public void start() throws IOException {
        if (this.started.compareAndSet(false, true)) {
            this.getMBeanServer();
            if (this.connectorServer != null) {
                try {
                    this.getMBeanServer().invoke(this.namingServiceObjectName, "start", null, null);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                Thread t = new Thread("JMX connector"){

                    public void run() {
                        try {
                            JMXConnectorServer server = MBeanServerContext.this.connectorServer;
                            if (MBeanServerContext.this.started.get() && server != null) {
                                server.start();
                                log.info((Object)("JMX consoles can connect to " + server.getAddress()));
                            }
                        }
                        catch (IOException e) {
                            log.warn((Object)("Failed to start jmx connector: " + e.getMessage()));
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
    }

    public void stop() throws IOException {
        if (this.started.compareAndSet(true, false)) {
            ArrayList<MBeanServer> list;
            JMXConnectorServer server = this.connectorServer;
            this.connectorServer = null;
            if (server != null) {
                try {
                    server.stop();
                }
                catch (IOException e) {
                    log.warn((Object)("Failed to stop jmx connector: " + e.getMessage()));
                }
                try {
                    this.getMBeanServer().invoke(this.namingServiceObjectName, "stop", null, null);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
                MBeanServerFactory.releaseMBeanServer(this.beanServer);
            }
        }
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public void setMBeanServer(MBeanServer beanServer) {
        this.beanServer = beanServer;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public boolean isFindTigerMbeanServer() {
        return this.findTigerMbeanServer;
    }

    public void setFindTigerMbeanServer(boolean findTigerMbeanServer) {
        this.findTigerMbeanServer = findTigerMbeanServer;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + MBeanServerContext.sanitizeString(type) + ",name=" + MBeanServerContext.sanitizeString(name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Couldn't create ObjectName from: " + type + " , " + name));
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + MBeanServerContext.getRelativeName(containerName, theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        if (this.beanServer != null && this.beanServer.isRegistered(name)) {
            this.beanServer.unregisterMBean(name);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            if (this.useMBeanServer) {
                ArrayList<MBeanServer> list;
                if (this.findTigerMbeanServer) {
                    result = MBeanServerContext.findTigerMBeanServer();
                }
                if (result == null && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                    result = (MBeanServer)list.get(0);
                }
            }
            if (result == null && this.createMBeanServer) {
                result = this.createMBeanServer();
            }
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"Couldnot load MBeanServer", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize MBeanServer", e);
        }
        return result;
    }

    public static MBeanServer findTigerMBeanServer() {
        block6: {
            String name = "java.lang.management.ManagementFactory";
            Class type = MBeanServerContext.loadClass(name, ManagementContext.class.getClassLoader());
            if (type != null) {
                try {
                    Method method = type.getMethod("getPlatformMBeanServer", new Class[0]);
                    if (method != null) {
                        Object answer = method.invoke(null, new Object[0]);
                        if (answer instanceof MBeanServer) {
                            return (MBeanServer)answer;
                        }
                        log.warn((Object)("Could not cast: " + answer + " into an MBeanServer. There must be some classloader strangeness in town"));
                        break block6;
                    }
                    log.warn((Object)("Method getPlatformMBeanServer() does not appear visible on type: " + type.getName()));
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to call getPlatformMBeanServer() due to: " + e), (Throwable)e);
                }
            } else {
                log.trace((Object)("Class not found: " + name + " so probably running on Java 1.4"));
            }
        }
        return null;
    }

    private static Class loadClass(String name, ClassLoader loader) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    protected MBeanServer createMBeanServer() throws MalformedObjectNameException, IOException {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
        this.locallyCreateMBeanServer = true;
        if (this.createConnector) {
            this.createConnector(mbeanServer);
        }
        return mbeanServer;
    }

    private void createConnector(MBeanServer mbeanServer) throws MalformedObjectNameException, MalformedURLException, IOException {
        try {
            LocateRegistry.createRegistry(this.connectorPort);
            this.namingServiceObjectName = ObjectName.getInstance("naming:type=rmiregistry");
            Class<?> cl = Class.forName("mx4j.tools.naming.NamingService");
            mbeanServer.registerMBean(cl.newInstance(), this.namingServiceObjectName);
            Attribute attr = new Attribute("Port", new Integer(this.connectorPort));
            mbeanServer.setAttribute(this.namingServiceObjectName, attr);
            mbeanServer.invoke(this.namingServiceObjectName, "start", null, null);
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to create local registry", e);
        }
        String serviceURL = "service:jmx:rmi:///jndi/rmi://localhost:" + this.connectorPort + this.connectorPath;
        JMXServiceURL url = new JMXServiceURL(serviceURL);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbeanServer);
    }

    public String getConnectorPath() {
        return this.connectorPath;
    }

    public void setConnectorPath(String connectorPath) {
        this.connectorPath = connectorPath;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }
}

