/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.EnvironmentContext;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseSystemService;
import org.apache.servicemix.jbi.management.MBeanBuilder;
import org.apache.servicemix.jbi.management.MBeanInfoProvider;
import org.apache.servicemix.jbi.management.MBeanServerContext;
import org.apache.servicemix.jbi.management.ManagementContextMBean;
import org.apache.servicemix.jbi.management.OperationInfoHelper;
import org.apache.servicemix.jbi.management.ParameterHelper;

public class ManagementContext
extends BaseSystemService
implements ManagementContextMBean {
    public static final String DEFAULT_DOMAIN = "org.apache.servicemix";
    public static final String DEFAULT_CONNECTOR_PATH = "/jmxrmi";
    public static final int DEFAULT_CONNECTOR_PORT = 1099;
    private static final Log log = LogFactory.getLog((Class)ManagementContext.class);
    private Map beanMap = new ConcurrentHashMap();
    protected Map systemServices = new ConcurrentHashMap();
    private MBeanServerContext mbeanServerContext = new MBeanServerContext();
    private ExecutorService executors;

    public ManagementContext() {
        this.mbeanServerContext.setJmxDomainName(DEFAULT_DOMAIN);
    }

    public String getDescription() {
        return "JMX Management";
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServerContext.getMBeanServer();
    }

    public String getJmxDomainName() {
        return this.mbeanServerContext.getJmxDomainName();
    }

    public boolean isUseMBeanServer() {
        return this.mbeanServerContext.isUseMBeanServer();
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.mbeanServerContext.setUseMBeanServer(useMBeanServer);
    }

    public boolean isCreateMBeanServer() {
        return this.mbeanServerContext.isCreateMBeanServer();
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.mbeanServerContext.setCreateMBeanServer(enableJMX);
    }

    public void setNamingPort(int portNum) {
        this.mbeanServerContext.setConnectorPort(portNum);
    }

    public int getNamingPort() {
        return this.mbeanServerContext.getConnectorPort();
    }

    public void init(JBIContainer container, MBeanServer server) throws JBIException {
        if (container.isEmbedded() && server == null) {
            this.mbeanServerContext.setUseMBeanServer(false);
            this.mbeanServerContext.setCreateMBeanServer(false);
        }
        this.mbeanServerContext.setMBeanServer(server);
        try {
            this.mbeanServerContext.start();
        }
        catch (IOException e) {
            log.error((Object)"Failed to start mbeanServerContext", (Throwable)e);
        }
        this.executors = Executors.newCachedThreadPool();
        super.init(container);
    }

    protected Class getServiceMBean() {
        return ManagementContextMBean.class;
    }

    public void start() throws JBIException {
        super.start();
    }

    public void stop() throws JBIException {
        super.stop();
    }

    public void shutDown() throws JBIException {
        super.shutDown();
        Object[] beans = this.beanMap.keySet().toArray();
        for (int i = 0; i < beans.length; ++i) {
            try {
                this.unregisterMBean(beans[i]);
                continue;
            }
            catch (Exception e) {
                log.debug((Object)"Could not unregister mbean", (Throwable)e);
            }
        }
        try {
            this.mbeanServerContext.stop();
        }
        catch (IOException e) {
            log.debug((Object)"Failed to shutdown mbeanServerContext cleanly", (Throwable)e);
        }
        this.executors.shutdown();
    }

    public ObjectName[] getBindingComponents() {
        return this.container.getRegistry().getBindingComponents();
    }

    public ObjectName getComponentByName(String componentName) {
        ComponentMBeanImpl component = this.container.getRegistry().getComponent(componentName);
        return component != null ? component.getMBeanName() : null;
    }

    public ObjectName[] getEngineComponents() {
        return this.container.getRegistry().getEngineComponents();
    }

    public ObjectName[] getPojoComponents() {
        return this.container.getRegistry().getPojoComponents();
    }

    public String getSystemInfo() {
        return "ServiceMix JBI Container: version: " + EnvironmentContext.getVersion();
    }

    public ObjectName getSystemService(String serviceName) {
        return (ObjectName)this.systemServices.get(serviceName);
    }

    public ObjectName[] getSystemServices() {
        ObjectName[] result = null;
        Collection col = this.systemServices.values();
        result = new ObjectName[col.size()];
        col.toArray(result);
        return result;
    }

    public boolean isBinding(String componentName) {
        ComponentMBeanImpl component = this.container.getRegistry().getComponent(componentName);
        return component != null ? component.isBinding() : false;
    }

    public boolean isEngine(String componentName) {
        ComponentMBeanImpl component = this.container.getRegistry().getComponent(componentName);
        return component != null ? component.isEngine() : false;
    }

    public String startComponent(String componentName) throws JBIException {
        ComponentMBeanImpl mbean;
        String result = "NOT FOUND: " + componentName;
        ObjectName objName = this.getComponentByName(componentName);
        if (objName != null && (mbean = (ComponentMBeanImpl)this.beanMap.get(objName)) != null) {
            mbean.start();
            result = mbean.getCurrentState();
        }
        return result;
    }

    public String stopComponent(String componentName) throws JBIException {
        ComponentMBeanImpl mbean;
        String result = "NOT FOUND: " + componentName;
        ObjectName objName = this.getComponentByName(componentName);
        if (objName != null && (mbean = (ComponentMBeanImpl)this.beanMap.get(objName)) != null) {
            mbean.stop();
            result = mbean.getCurrentState();
        }
        return result;
    }

    public String shutDownComponent(String componentName) throws JBIException {
        ComponentMBeanImpl mbean;
        String result = "NOT FOUND: " + componentName;
        ObjectName objName = this.getComponentByName(componentName);
        if (objName != null && (mbean = (ComponentMBeanImpl)this.beanMap.get(objName)) != null) {
            mbean.shutDown();
            result = mbean.getCurrentState();
        }
        return result;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("ContainerName", this.container.getName());
        result.put("Type", "Component");
        result.put("Name", ManagementContext.sanitizeString(name));
        result.put("SubType", ManagementContext.sanitizeString(type));
        return this.createObjectName(result);
    }

    public ObjectName createObjectName(MBeanInfoProvider provider) {
        Map props = this.createObjectNameProps(provider);
        return this.createObjectName(props);
    }

    public ObjectName createObjectName(String name) {
        ObjectName result = null;
        try {
            result = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            String error = "Could not create ObjectName for " + name;
            log.error((Object)error, (Throwable)e);
            throw new RuntimeException(error);
        }
        return result;
    }

    public ObjectName createObjectName(String domain, Map props) {
        StringBuffer sb = new StringBuffer();
        sb.append(domain).append(':');
        int i = 0;
        Iterator it = props.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        ObjectName result = null;
        try {
            result = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            String error = "Could not create ObjectName for " + props;
            log.error((Object)error, (Throwable)e);
            throw new RuntimeException(error);
        }
        return result;
    }

    public ObjectName createObjectName(Map props) {
        return this.createObjectName(this.getJmxDomainName(), props);
    }

    public Map createObjectNameProps(MBeanInfoProvider provider) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("ContainerName", this.container.getName());
        result.put("Type", ManagementContext.sanitizeString(provider.getType()));
        result.put("Name", ManagementContext.sanitizeString(provider.getName()));
        if (provider.getSubType() != null) {
            result.put("SubType", ManagementContext.sanitizeString(provider.getSubType()));
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }

    public void registerMBean(ObjectName name, MBeanInfoProvider resource, Class interfaceMBean) throws JMException {
        this.registerMBean(name, resource, interfaceMBean, resource.getDescription());
    }

    public void registerMBean(ObjectName name, Object resource, Class interfaceMBean, String description) throws JMException {
        if (this.mbeanServerContext.getMBeanServer() != null) {
            DynamicMBean mbean = MBeanBuilder.buildStandardMBean(resource, interfaceMBean, description, this.executors);
            if (this.mbeanServerContext.getMBeanServer().isRegistered(name)) {
                this.mbeanServerContext.getMBeanServer().unregisterMBean(name);
            }
            this.mbeanServerContext.getMBeanServer().registerMBean(mbean, name);
            this.beanMap.put(name, resource);
        }
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class interfaceType) {
        String tmp = domainName + ":ContainerName=" + containerName + ",Type=SystemService,Name=" + ManagementContext.getSystemServiceName(interfaceType);
        ObjectName result = null;
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)"Failed to build ObjectName:", (Throwable)e);
        }
        return result;
    }

    public static String getSystemServiceName(Class interfaceType) {
        String name = interfaceType.getName();
        if ((name = name.substring(name.lastIndexOf(46) + 1)).endsWith("MBean")) {
            name = name.substring(0, name.length() - 5);
        }
        return name;
    }

    public static ObjectName getContainerObjectName(String domainName, String containerName) {
        String tmp = domainName + ":ContainerName=" + containerName + ",Type=JBIContainer";
        ObjectName result = null;
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void registerSystemService(BaseSystemService service, Class interfaceType) throws JBIException {
        try {
            String name = service.getName();
            if (this.systemServices.containsKey(name)) {
                throw new JBIException("A system service for the name " + name + " is already registered");
            }
            ObjectName objName = this.createObjectName(service);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering system service: " + objName));
            }
            this.registerMBean(objName, service, interfaceType, service.getDescription());
            this.systemServices.put(name, objName);
        }
        catch (MalformedObjectNameException e) {
            throw new JBIException((Throwable)e);
        }
        catch (JMException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public void unregisterMBean(ObjectName name) throws JBIException {
        try {
            this.mbeanServerContext.unregisterMBean(name);
            this.beanMap.remove(name);
        }
        catch (JMException e) {
            log.error((Object)("Failed to unregister mbean: " + name), (Throwable)e);
            throw new JBIException((Throwable)e);
        }
    }

    public void unregisterMBean(Object bean) throws JBIException {
        Iterator i = this.beanMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getValue() != bean) continue;
            ObjectName name = (ObjectName)entry.getKey();
            this.unregisterMBean(name);
            break;
        }
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "bindingComponents", "Get list of all binding components");
        helper.addAttribute(this.getObjectToManage(), "engineComponents", "Get list of all engine components");
        helper.addAttribute(this.getObjectToManage(), "pojoComponents", "Get list of all pojo components");
        helper.addAttribute(this.getObjectToManage(), "systemInfo", "Return current version");
        helper.addAttribute(this.getObjectToManage(), "systemServices", "Get list of system services");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public MBeanOperationInfo[] getOperationInfos() throws JMException {
        OperationInfoHelper helper = new OperationInfoHelper();
        ParameterHelper ph = helper.addOperation(this.getObjectToManage(), "getComponentByName", 1, "look up Component by name");
        ph.setDescription(0, "name", "Component name");
        ph = helper.addOperation(this.getObjectToManage(), "getSystemService", 1, "look up System service by name");
        ph.setDescription(0, "name", "System name");
        ph = helper.addOperation(this.getObjectToManage(), "isBinding", 1, "Is Component a binding Component?");
        ph.setDescription(0, "name", "Component name");
        ph = helper.addOperation(this.getObjectToManage(), "isEngine", 1, "Is Component a service engine?");
        ph.setDescription(0, "name", "Component name");
        return OperationInfoHelper.join(super.getOperationInfos(), helper.getOperationInfos());
    }
}

