/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.management.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.servicemix.jbi.framework.AdminCommandsServiceMBean;
import org.apache.servicemix.jbi.management.task.JbiTask;
import org.apache.tools.ant.BuildException;

public class InstallComponentTask
extends JbiTask {
    private String file;
    private String paramsFile;
    private List nestedParams;

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getParams() {
        return this.paramsFile;
    }

    public void setParams(String paramsFile) {
        this.paramsFile = paramsFile;
    }

    public Param createParam() {
        Param p = new Param();
        if (this.nestedParams == null) {
            this.nestedParams = new ArrayList();
        }
        this.nestedParams.add(p);
        return p;
    }

    public void doExecute(AdminCommandsServiceMBean acs) throws Exception {
        if (this.file == null) {
            throw new BuildException("null file - file should be an archive");
        }
        if (!this.file.endsWith(".zip") && !this.file.endsWith(".jar")) {
            throw new BuildException("file: " + this.file + " is not an archive");
        }
        File archive = new File(this.file);
        if (!archive.isFile()) {
            throw new BuildException("file: " + this.file + " not found");
        }
        Properties props = this.getProperties();
        acs.installComponent(archive.getAbsolutePath(), props);
    }

    private Properties getProperties() throws IOException {
        Properties props = new Properties();
        if (this.paramsFile != null) {
            props.load(new FileInputStream(this.paramsFile));
        }
        if (this.nestedParams != null) {
            Iterator iter = this.nestedParams.iterator();
            while (iter.hasNext()) {
                Param p = (Param)iter.next();
                props.setProperty(p.getName(), p.getValue());
            }
        }
        return props;
    }

    public static class Param {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

