/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.nmr.flow.seda;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.framework.ComponentNameSpace;
import org.apache.servicemix.jbi.management.AttributeInfoHelper;
import org.apache.servicemix.jbi.management.BaseLifeCycle;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.nmr.flow.seda.SedaFlow;
import org.apache.servicemix.jbi.util.BoundedLinkedQueue;

public class SedaQueue
extends BaseLifeCycle
implements Work {
    private static final Log log = LogFactory.getLog((Class)SedaQueue.class);
    protected SedaFlow flow;
    protected ComponentNameSpace name;
    protected BoundedLinkedQueue queue;
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected ObjectName objectName;
    protected String subType;
    protected Thread thread;

    public SedaQueue(ComponentNameSpace name) {
        this.name = name;
    }

    public String getName() {
        return this.name.getName();
    }

    public String getType() {
        return "SedaQueue";
    }

    public ComponentNameSpace getComponentNameSpace() {
        return this.name;
    }

    public String getDescription() {
        return "bounded worker Queue for the NMR";
    }

    public void init(SedaFlow flow, int capacity) {
        this.flow = flow;
        this.queue = new BoundedLinkedQueue(capacity);
    }

    public void setCapacity(int value) {
        int oldValue = this.queue.capacity();
        this.queue.setCapacity(value);
        super.firePropertyChanged("capacity", new Integer(oldValue), new Integer(value));
    }

    public int getCapacity() {
        return this.queue.capacity();
    }

    public int getSize() {
        return this.queue.size();
    }

    public void enqueue(MessageExchange me) throws InterruptedException, MessagingException {
        this.queue.put(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JBIException {
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            try {
                this.started.set(true);
                this.flow.getBroker().getContainer().getWorkManager().startWork((Work)this);
                this.running.wait();
                super.start();
            }
            catch (Exception e) {
                throw new JBIException("Unable to start queue work", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JBIException {
        this.started.set(false);
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            if (this.thread != null && this.running.get()) {
                try {
                    this.thread.interrupt();
                    this.running.wait();
                }
                catch (Exception e) {
                    log.warn((Object)"Error stopping thread", (Throwable)e);
                }
                finally {
                    this.thread = null;
                }
            }
        }
        super.stop();
    }

    public void shutDown() throws JBIException {
        this.stop();
        super.shutDown();
    }

    public void release() {
        log.info((Object)("SedaQueue " + this.name + " asked to be released"));
        try {
            this.shutDown();
        }
        catch (JBIException e) {
            log.warn((Object)"Caught an exception shutting down", (Throwable)e);
        }
        this.flow.release(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread = Thread.currentThread();
        AtomicBoolean atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.running.set(true);
            this.running.notify();
        }
        while (this.started.get()) {
            try {
                final MessageExchangeImpl me = (MessageExchangeImpl)this.queue.poll(1000L);
                if (me == null) continue;
                this.flow.getBroker().getContainer().getWorkManager().scheduleWork(new Work(){

                    public void release() {
                    }

                    public void run() {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this + " dequeued exchange: " + me));
                            }
                            SedaQueue.this.flow.doRouting(me);
                        }
                        catch (Throwable e) {
                            log.error((Object)(this + " got error processing " + me), e);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                if (!this.started.get()) break;
                log.warn((Object)(this + " interrupted"), (Throwable)e);
            }
            catch (WorkException e) {
                log.error((Object)(this + " got error processing exchange"), (Throwable)e);
            }
        }
        atomicBoolean = this.running;
        synchronized (atomicBoolean) {
            this.running.set(false);
            this.running.notify();
        }
    }

    public String toString() {
        return "SedaQueue{" + this.name + "}";
    }

    public MBeanAttributeInfo[] getAttributeInfos() throws JMException {
        AttributeInfoHelper helper = new AttributeInfoHelper();
        helper.addAttribute(this.getObjectToManage(), "capacity", "The capacity of the SedaQueue");
        helper.addAttribute(this.getObjectToManage(), "size", "The size (depth) of the SedaQueue");
        return AttributeInfoHelper.join(super.getAttributeInfos(), helper.getAttributeInfos());
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }
}

