/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.security.acl.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.security.GroupPrincipal;

public class AuthorizationEntry {
    public static final String TYPE_ADD = "add";
    public static final String TYPE_SET = "set";
    public static final String TYPE_REM = "rem";
    private Set acls;
    private QName service;
    private String endpoint;
    private String type = "add";

    public AuthorizationEntry() {
    }

    public AuthorizationEntry(QName service, String endpoint, String roles) {
        this.service = service;
        this.endpoint = endpoint;
        this.setRoles(roles);
    }

    public AuthorizationEntry(QName service, String endpoint, String roles, String type) {
        this.service = service;
        this.endpoint = endpoint;
        this.setRoles(roles);
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        if ("".equals(service.getNamespaceURI()) && service.getPrefix() != null && service.getPrefix().length() > 0) {
            service = new QName(service.getPrefix(), service.getLocalPart());
        }
        this.service = service;
    }

    public Set getAcls() {
        return this.acls;
    }

    public void setAcls(Set acls) {
        this.acls = acls;
    }

    public void setRoles(String roles) {
        this.acls = new HashSet();
        StringTokenizer iter = new StringTokenizer(roles, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            this.acls.add(new GroupPrincipal(name));
        }
    }

    public String getRoles() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.acls.iterator();
        while (iter.hasNext()) {
            GroupPrincipal p = (GroupPrincipal)iter.next();
            sb.append(p);
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        return "AuthorizationEntry[service=" + this.service + ", endpoint=" + this.endpoint + ", roles=" + this.getRoles() + "]";
    }
}

