/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.container.ContainerAware;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.Endpoint;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.view.EndpointViewRenderer;

public class DotViewEndpointListener
extends EndpointViewRenderer
implements ContainerAware {
    private static final Log log = LogFactory.getLog((Class)DotViewEndpointListener.class);
    private JBIContainer container;
    private String file = "ServiceMixComponents.dot";

    public JBIContainer getContainer() {
        return this.container;
    }

    public void setContainer(JBIContainer container) {
        this.container = container;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating DOT file at: " + this.file));
        }
        PrintWriter writer = new PrintWriter(new FileWriter(this.file));
        try {
            this.generateFile(writer);
        }
        finally {
            writer.close();
        }
    }

    protected void generateFile(PrintWriter writer) throws Exception {
        writer.println("digraph \"Apache ServiceMix\" {");
        writer.println();
        writer.println("node [style = \"rounded,filled\", fillcolor = yellow, fontname=\"Helvetica-Oblique\"];");
        writer.println();
        writer.println("jbi [label=\"Apache ServiceMix: " + this.container.getName() + "\"];");
        writer.println();
        writer.println("node [fillcolor = green];");
        writer.println();
        ArrayList<String> brokerLinks = new ArrayList<String>();
        Registry registry = this.container.getRegistry();
        Collection components = registry.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            ComponentMBeanImpl component = (ComponentMBeanImpl)iter.next();
            String name = component.getName();
            String id = this.encode(name);
            writer.print(id);
            writer.print(" [ label=\"");
            writer.print(name);
            writer.println("\" ];");
            brokerLinks.add("jbi -> " + id);
        }
        writer.println();
        this.generateLinks(writer, brokerLinks);
        writer.println("node [fillcolor = red];");
        writer.println();
        ArrayList<String> componentEndpointLinks = new ArrayList<String>();
        Collection endpointMBeans = registry.getEndpointRegistry().getEndpointMBeans();
        Iterator iter2 = endpointMBeans.iterator();
        while (iter2.hasNext()) {
            Endpoint endpoint = (Endpoint)iter2.next();
            String name = endpoint.getEndpointName();
            String componentName = this.encode(endpoint.getComponentName());
            String id = this.encode(name);
            writer.print(id);
            writer.print(" [ label=\"");
            writer.print(name);
            writer.println("\" ];");
            componentEndpointLinks.add(componentName + " -> " + id);
        }
        this.generateLinks(writer, componentEndpointLinks);
        writer.println("}");
    }

    protected void generateLinks(PrintWriter writer, Collection lines, String style) {
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            writer.print(iter.next().toString());
            if (style != null) {
                writer.print(" [" + style + "]");
            }
            writer.println(";");
        }
        writer.println();
    }

    protected void generateLinks(PrintWriter writer, Collection lines) {
        this.generateLinks(writer, lines, null);
    }

    protected String encode(String name) {
        StringBuffer buffer = new StringBuffer();
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') {
                buffer.append(ch);
                continue;
            }
            buffer.append('_');
        }
        return buffer.toString();
    }
}

