/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.view;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.servicemix.jbi.event.ComponentEvent;
import org.apache.servicemix.jbi.event.ComponentListener;
import org.apache.servicemix.jbi.event.EndpointEvent;
import org.apache.servicemix.jbi.event.ExchangeEvent;
import org.apache.servicemix.jbi.event.ExchangeListener;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.apache.servicemix.jbi.framework.Registry;
import org.apache.servicemix.jbi.messaging.MessageExchangeImpl;
import org.apache.servicemix.jbi.servicedesc.EndpointSupport;
import org.apache.servicemix.jbi.view.DotViewEndpointListener;

public class DotViewFlowListener
extends DotViewEndpointListener
implements ExchangeListener,
ComponentListener {
    private Map flow;
    private Set flowLinks;

    public DotViewFlowListener() {
        this.setFile("ServiceMixFlow.dot");
        this.flow = new ConcurrentHashMap();
        this.flowLinks = new CopyOnWriteArraySet();
    }

    protected void generateFile(PrintWriter writer) throws Exception {
        writer.println("digraph \"Apache ServiceMix\" {");
        writer.println();
        writer.println("label = \"Apache ServiceMix flow\";");
        writer.println("node [style = \"rounded,filled\", fillcolor = yellow, fontname=\"Helvetica-Oblique\"];");
        writer.println();
        ArrayList brokerLinks = new ArrayList();
        Registry registry = this.getContainer().getRegistry();
        Collection components = registry.getComponents();
        Iterator iter = components.iterator();
        while (iter.hasNext()) {
            ComponentMBeanImpl component = (ComponentMBeanImpl)iter.next();
            ServiceEndpoint[] ses = registry.getEndpointsForComponent(component.getComponentNameSpace());
            String name = component.getName();
            String id = this.encode(name);
            writer.println("subgraph cluster_" + id + " {");
            writer.println("  label=\"" + name + "\";");
            writer.println("  node [fillcolor = green];");
            writer.println("  " + id + " [label=\"" + name + "\"];");
            writer.println("  node [fillcolor = red];");
            for (int i = 0; i < ses.length; ++i) {
                String epname = EndpointSupport.getKey(ses[i]);
                String epid = this.encode(epname);
                writer.println("  " + epid + " [label=\"" + epname + "\"];");
            }
            writer.println("}");
        }
        writer.println();
        this.generateLinks(writer, brokerLinks);
        writer.println();
        this.generateLinks(writer, this.flowLinks);
        writer.println("}");
    }

    public void exchangeSent(ExchangeEvent event) {
        MessageExchange me = event.getExchange();
        if (me.getEndpoint() != null && me instanceof MessageExchangeImpl) {
            MessageExchangeImpl mei = (MessageExchangeImpl)me;
            String source = (String)me.getProperty("org.apache.servicemix.senderEndpoint");
            if (source == null) {
                source = mei.getSourceId().getName();
            }
            String dest = EndpointSupport.getKey(mei.getEndpoint());
            Map componentFlow = (Map)this.flow.get(source);
            if (componentFlow.put(dest, Boolean.TRUE) == null) {
                this.flowLinks.add(this.encode(source) + " -> " + this.encode(dest));
                this.viewIsDirty(mei.getEndpoint());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSource(String name) {
        Map map = this.flow;
        synchronized (map) {
            Map componentFlow = (Map)this.flow.get(name);
            if (componentFlow == null) {
                componentFlow = new ConcurrentHashMap();
                this.flow.put(name, componentFlow);
            }
        }
    }

    public void internalEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getKey(event.getEndpoint());
        this.createSource(key);
        super.internalEndpointRegistered(event);
    }

    public void externalEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getKey(event.getEndpoint());
        this.createSource(key);
        super.externalEndpointRegistered(event);
    }

    public void linkedEndpointRegistered(EndpointEvent event) {
        String key = EndpointSupport.getKey(event.getEndpoint());
        this.createSource(key);
        super.linkedEndpointRegistered(event);
    }

    public void componentInstalled(ComponentEvent event) {
        this.createSource(event.getComponent().getName());
    }

    public void componentStarted(ComponentEvent event) {
        this.createSource(event.getComponent().getName());
    }

    public void componentStopped(ComponentEvent event) {
    }

    public void componentShutDown(ComponentEvent event) {
    }

    public void componentUninstalled(ComponentEvent event) {
    }
}

