/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.tck.MessageList;
import org.apache.servicemix.tck.Receiver;
import org.apache.servicemix.tck.ReceiverPojo;

public class AsyncReceiverPojo
implements ComponentLifeCycle,
Receiver,
Runnable {
    public static final QName SERVICE = ReceiverPojo.SERVICE;
    public static final String ENDPOINT = "receiver";
    private static final Log log = LogFactory.getLog((Class)AsyncReceiverPojo.class);
    private ComponentContext context;
    private MessageList messageList = new MessageList();
    private Thread runner;
    private boolean running;

    public void init(ComponentContext context) throws JBIException {
        this.context = context;
        context.activateEndpoint(SERVICE, ENDPOINT);
    }

    public void shutDown() throws JBIException {
    }

    public synchronized void start() throws JBIException {
        if (!this.running) {
            this.running = true;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public synchronized void stop() throws JBIException {
        this.running = false;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public MessageList getMessageList() {
        return this.messageList;
    }

    public void run() {
        while (this.running) {
            try {
                DeliveryChannel deliveryChannel = this.context.getDeliveryChannel();
                log.info((Object)("about to do an accept on deliveryChannel: " + deliveryChannel));
                MessageExchange messageExchange = deliveryChannel.accept();
                log.info((Object)("received me: " + messageExchange));
                this.onMessageExchange(messageExchange);
            }
            catch (MessagingException e) {
                log.error((Object)("Failed to process inbound messages: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        NormalizedMessage inMessage = exchange.getMessage("in");
        this.messageList.addMessage(inMessage);
        exchange.setStatus(ExchangeStatus.DONE);
        this.context.getDeliveryChannel().send(exchange);
    }

    public ComponentContext getContext() {
        return this.context;
    }
}

