/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import java.util.ArrayList;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.client.Message;
import org.apache.servicemix.client.MessageListener;

public class MessageList
extends Assert
implements MessageListener {
    private static final Log log = LogFactory.getLog((Class)MessageList.class);
    private List messages = new ArrayList();
    private Object semaphore;

    public MessageList() {
        this(new Object());
    }

    public MessageList(Object semaphore) {
        this.semaphore = semaphore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List flushMessages() {
        Object object = this.semaphore;
        synchronized (object) {
            ArrayList answer = new ArrayList(this.messages);
            this.messages.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getMessages() {
        Object object = this.semaphore;
        synchronized (object) {
            return new ArrayList(this.messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(NormalizedMessage message) throws MessagingException {
        Object object = this.semaphore;
        synchronized (object) {
            this.messages.add(message);
            this.semaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String message) throws MessagingException {
        Object object = this.semaphore;
        synchronized (object) {
            this.messages.add(message);
            this.semaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        Object object = this.semaphore;
        synchronized (object) {
            return this.messages.size();
        }
    }

    public void waitForMessagesToArrive(int messageCount) {
        this.waitForMessagesToArrive(messageCount, 4000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount, long baseTimeout) {
        log.info((Object)"Waiting for message to arrive");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < baseTimeout + (long)(100 * messageCount)) {
            try {
                if (!this.hasReceivedMessages(messageCount)) {
                    Object object = this.semaphore;
                    synchronized (object) {
                        this.semaphore.wait(4000L);
                        continue;
                    }
                }
                break;
            }
            catch (InterruptedException e) {
                log.info((Object)("Caught: " + e));
            }
        }
        long end = System.currentTimeMillis() - start;
        log.info((Object)("End of wait for " + end + " millis"));
    }

    public void assertMessagesReceived(int messageCount) {
        this.waitForMessagesToArrive(messageCount);
        MessageList.assertEquals((String)("expected number of messages when received: " + this.getMessages()), (int)messageCount, (int)this.getMessageCount());
    }

    public boolean hasReceivedMessage() {
        return this.getMessageCount() > 0;
    }

    public boolean hasReceivedMessages(int messageCount) {
        return this.getMessageCount() >= messageCount;
    }

    public void onMessage(MessageExchange exchange, Message message) throws Exception {
        this.addMessage(message);
    }
}

