/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.tck;

import java.io.IOException;
import java.util.Date;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.servicemix.client.ServiceMixClient;
import org.apache.servicemix.jbi.container.SpringJBIContainer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.jbi.resolver.ServiceNameEndpointResolver;
import org.apache.servicemix.tck.MessageList;
import org.apache.servicemix.tck.Receiver;
import org.apache.servicemix.tck.SpringTestSupport;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class TestSupport
extends SpringTestSupport {
    protected ServiceMixClient client;
    protected Receiver receiver;

    protected void setUp() throws Exception {
        super.setUp();
        this.client = (ServiceMixClient)this.getBean("client");
        SpringJBIContainer jbi = (SpringJBIContainer)this.getBean("jbi");
        this.receiver = (Receiver)jbi.getBean("receiver");
    }

    protected void assertSendAndReceiveMessages(QName service) throws Exception {
        this.sendMessages(service, this.messageCount);
        this.assertMessagesReceived(this.messageCount);
    }

    protected void sendMessages(QName service, int messageCount) throws Exception {
        this.sendMessages(service, messageCount, true, null);
    }

    protected void sendMessages(QName service, int messageCount, String message) throws Exception {
        this.sendMessages(service, messageCount, true, message);
    }

    protected void sendMessages(QName service, int messageCount, boolean sync, String msg) throws Exception {
        for (int i = 1; i <= messageCount; ++i) {
            InOnly exchange = this.client.createInOnlyExchange();
            NormalizedMessage message = exchange.getInMessage();
            message.setProperty("name", (Object)"James");
            message.setProperty("id", (Object)new Integer(i));
            message.setProperty("idText", (Object)("" + i));
            if (msg != null && msg.length() > 0) {
                message.setContent((Source)new StringSource(msg));
            } else {
                message.setContent((Source)new StringSource(this.createMessageXmlText(i)));
            }
            exchange.setService(service);
            if (sync) {
                this.client.sendSync((MessageExchange)exchange);
            } else {
                this.client.send((MessageExchange)exchange);
            }
            Exception error = exchange.getError();
            if (error != null) {
                throw error;
            }
            Fault fault = exchange.getFault();
            TestSupport.assertEquals((String)"Should have no fault!", null, (Object)fault);
        }
    }

    protected String createMessageXmlText(int index) {
        return "<sample id='" + index + "' sent='" + new Date() + "'>hello world!</sample>";
    }

    protected void assertMessagesReceived() throws Exception {
        this.assertMessagesReceived(this.messageCount);
    }

    protected void assertMessagesReceived(int messageCount) throws Exception {
        TestSupport.assertNotNull((String)"receiver not found in JBI container", (Object)this.receiver);
        MessageList messageList = this.receiver.getMessageList();
        this.assertMessagesReceived(messageList, messageCount);
    }

    protected MessageList assertMessagesReceived(String receiverName, int messageCount) throws Exception {
        Receiver receiver = (Receiver)this.getBean(receiverName);
        TestSupport.assertNotNull((String)("receiver: " + receiverName + " not found in JBI container"), (Object)receiver);
        MessageList messageList = receiver.getMessageList();
        this.assertMessagesReceived(messageList, messageCount);
        return messageList;
    }

    protected Object requestServiceWithFileRequest(QName serviceName, String fileOnClassPath) throws Exception {
        ServiceNameEndpointResolver resolver = new ServiceNameEndpointResolver(serviceName);
        Source content = this.getSourceFromClassPath(fileOnClassPath);
        Object answer = this.client.request(resolver, null, null, content);
        if (answer instanceof Source) {
            answer = this.transformer.toDOMNode((Source)answer);
        }
        return answer;
    }

    protected void sendServiceWithFileRequest(QName serviceName, String fileOnClassPath) throws Exception {
        Source content = this.getSourceFromClassPath(fileOnClassPath);
        ServiceNameEndpointResolver resolver = new ServiceNameEndpointResolver(serviceName);
        this.client.send(resolver, null, null, content);
    }

    protected void assertMessageHeader(MessageList messageList, int index, String propertyName, Object expectedValue) {
        NormalizedMessage message = (NormalizedMessage)messageList.getMessages().get(index);
        TestSupport.assertNotNull((String)("Message: " + index + " is null!"), (Object)message);
        Object value = message.getProperty(propertyName);
        TestSupport.assertEquals((String)("property: " + propertyName), (Object)expectedValue, (Object)value);
    }

    protected void assertMessageBody(MessageList messageList, int index, String expectedXml) throws TransformerException {
        NormalizedMessage message = (NormalizedMessage)messageList.getMessages().get(index);
        TestSupport.assertNotNull((String)("Message: " + index + " is null!"), (Object)message);
        Source content = message.getContent();
        TestSupport.assertNotNull((String)("Message content: " + index + " is null!"), (Object)content);
        String value = this.transformer.toString(content);
        TestSupport.assertEquals((String)("message XML for: " + index), (String)expectedXml, (String)value);
    }

    protected void assertMessageXPath(MessageList messageList, int index, String xpath, String expectedValue) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        NormalizedMessage message = (NormalizedMessage)messageList.getMessages().get(index);
        TestSupport.assertNotNull((String)("Message: " + index + " is null!"), (Object)message);
        Source content = message.getContent();
        TestSupport.assertNotNull((String)("Message content: " + index + " is null!"), (Object)content);
        Node node = this.transformer.toDOMNode(content);
        String value = this.textValueOfXPath(node, xpath);
        String xmlText = this.transformer.toString(node);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message: " + index + " received XML: " + xmlText));
        }
        TestSupport.assertEquals((String)("message XML: " + index + " for xpath: " + xpath + " body was: " + xmlText), (String)expectedValue, (String)value);
    }
}

