/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.XAWork;
import org.apache.geronimo.transaction.context.BeanTransactionContext;
import org.apache.geronimo.transaction.context.ContainerTransactionContext;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionContextManager
implements XATerminator,
XAWork {
    private static final Log log;
    private static final boolean NOT_IN_RECOVERY = false;
    private static final boolean IN_RECOVERY = true;
    private ThreadLocal CONTEXT = new ThreadLocal();
    private final ExtendedTransactionManager transactionManager;
    private final XidImporter importer;
    private final Map importedTransactions = new HashMap();
    private boolean recoveryState = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionContextManager() {
        this(null, null);
    }

    public TransactionContextManager(ExtendedTransactionManager transactionManager, XidImporter importer) {
        this.transactionManager = transactionManager;
        this.importer = importer;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionTimeout(int timeoutSeconds) throws SystemException {
        this.transactionManager.setTransactionTimeout(timeoutSeconds);
    }

    public TransactionContext getContext() {
        return (TransactionContext)this.CONTEXT.get();
    }

    public void setContext(TransactionContext transactionContext) {
        this.CONTEXT.set(transactionContext);
    }

    public TransactionContext newContainerTransactionContext() throws NotSupportedException, SystemException {
        ContainerTransactionContext transactionContext = new ContainerTransactionContext(this.transactionManager);
        this.setContext(transactionContext);
        return transactionContext;
    }

    public TransactionContext newBeanTransactionContext(long transactionTimeoutMilliseconds) throws NotSupportedException, SystemException {
        TransactionContext ctx = this.getContext();
        if (!(ctx instanceof UnspecifiedTransactionContext)) {
            throw new NotSupportedException("Previous Transaction has not been committed");
        }
        UnspecifiedTransactionContext oldContext = (UnspecifiedTransactionContext)ctx;
        BeanTransactionContext transactionContext = new BeanTransactionContext(this.transactionManager, oldContext);
        oldContext.suspend();
        try {
            transactionContext.begin(transactionTimeoutMilliseconds);
        }
        catch (SystemException e) {
            oldContext.resume();
            throw e;
        }
        catch (NotSupportedException e) {
            oldContext.resume();
            throw e;
        }
        this.setContext(transactionContext);
        return transactionContext;
    }

    public TransactionContext newUnspecifiedTransactionContext() {
        UnspecifiedTransactionContext transactionContext = new UnspecifiedTransactionContext();
        this.setContext(transactionContext);
        return transactionContext;
    }

    public TransactionContext suspendBeanTransactionContext() throws SystemException {
        TransactionContext callerContext = this.getContext();
        if (!(callerContext instanceof BeanTransactionContext)) {
            throw new SystemException("Caller context is not a bean managed  transaction context");
        }
        BeanTransactionContext beanContext = (BeanTransactionContext)callerContext;
        UnspecifiedTransactionContext oldContext = beanContext.getOldContext();
        beanContext.setOldContext(null);
        try {
            beanContext.suspend();
            BeanTransactionContext beanTransactionContext = beanContext;
            return beanTransactionContext;
        }
        catch (SystemException e) {
            if (beanContext.isActive()) {
                try {
                    beanContext.rollback();
                }
                catch (SystemException e1) {
                    log.warn((Object)"Unable to rollback transaction", (Throwable)e);
                }
            }
            throw e;
        }
        finally {
            this.setContext(oldContext);
            oldContext.resume();
            this.setContext(oldContext);
        }
    }

    public void resumeBeanTransactionContext(TransactionContext context) throws SystemException, InvalidTransactionException {
        if (!(context instanceof BeanTransactionContext)) {
            throw new InvalidTransactionException("Context is not a bean managed transaction context");
        }
        if (!context.isActive()) {
            throw new InvalidTransactionException("Context is not active");
        }
        BeanTransactionContext beanContext = (BeanTransactionContext)context;
        TransactionContext callerContext = this.getContext();
        if (!(callerContext instanceof UnspecifiedTransactionContext)) {
            throw new InvalidTransactionException("Caller context is not an unspecified transaction context");
        }
        callerContext.suspend();
        try {
            beanContext.setOldContext((UnspecifiedTransactionContext)callerContext);
            context.resume();
            this.setContext(context);
        }
        catch (SystemException e) {
            if (beanContext.isActive()) {
                try {
                    beanContext.rollback();
                }
                catch (SystemException e1) {
                    log.warn((Object)"Unable to rollback transaction", (Throwable)e);
                }
            }
            beanContext.setOldContext(null);
            callerContext.resume();
            throw e;
        }
        catch (InvalidTransactionException e) {
            if (beanContext.isActive()) {
                try {
                    beanContext.rollback();
                }
                catch (SystemException e1) {
                    log.warn((Object)"Unable to rollback transaction", (Throwable)e);
                }
            }
            beanContext.setOldContext(null);
            callerContext.resume();
            throw e;
        }
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public void setRollbackOnly() throws SystemException {
        this.transactionManager.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = containerTransactionContext.getTransaction().getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError((Object)("invalid status: " + status));
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.commit(containerTransactionContext.getTransaction(), onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        this.importer.forget(containerTransactionContext.getTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        Transaction tx = containerTransactionContext.getTransaction();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        return this.importer.prepare(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        if (!this.recoveryState) {
            if ((flag & 0x1000000) == 0) {
                throw new XAException(-6);
            }
            this.recoveryState = true;
        }
        if ((flag & 0x800000) != 0) {
            this.recoveryState = false;
        }
        if ((flag & 0x1000000) != 0) {
            Map recoveredXidMap = this.transactionManager.getExternalXids();
            Xid[] recoveredXids = new Xid[recoveredXidMap.size()];
            int i = 0;
            Map map = this.importedTransactions;
            synchronized (map) {
                Iterator iterator = recoveredXidMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Xid xid = (Xid)entry.getKey();
                    recoveredXids[i++] = xid;
                    ContainerTransactionContext containerTransactionContext = new ContainerTransactionContext(this.transactionManager, (Transaction)entry.getValue());
                    this.importedTransactions.put(xid, containerTransactionContext);
                }
            }
            return recoveredXids;
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        Transaction tx = containerTransactionContext.getTransaction();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.rollback(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(Xid xid, long txTimeoutMillis) throws XAException, InvalidTransactionException, SystemException, ImportedTransactionActiveException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
            if (containerTransactionContext == null) {
                Transaction transaction = this.importer.importXid(xid, txTimeoutMillis);
                containerTransactionContext = new ContainerTransactionContext(this.transactionManager, transaction);
                this.importedTransactions.put(xid, containerTransactionContext);
            } else if (containerTransactionContext.isThreadAssociated()) {
                throw new ImportedTransactionActiveException(xid);
            }
            containerTransactionContext.resume();
        }
        this.setContext(containerTransactionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid) throws XAException, SystemException {
        this.setContext(null);
        Map map = this.importedTransactions;
        synchronized (map) {
            ContainerTransactionContext containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
            if (containerTransactionContext == null) {
                throw new XAException("No imported transaction for xid: " + xid);
            }
            if (!containerTransactionContext.isThreadAssociated()) {
                throw new XAException("tx not active for containerTransactionContext: " + containerTransactionContext + ", xid: " + xid);
            }
            containerTransactionContext.suspend();
        }
    }

    static {
        $assertionsDisabled = !TransactionContextManager.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)TransactionContextManager.class);
    }
}

