/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.jndi.JNDIBaseStorable;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.management.StatsCapable;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.URISupport;

public class ActiveMQConnectionFactory
extends JNDIBaseStorable
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
StatsCapable,
Cloneable {
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_USER = null;
    public static final String DEFAULT_PASSWORD = null;
    protected URI brokerURL;
    protected String userName;
    protected String password;
    protected String clientID;
    private ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
    private RedeliveryPolicy redeliveryPolicy = new RedeliveryPolicy();
    private boolean disableTimeStampsByDefault = false;
    private boolean onSendPrepareMessageBody = true;
    private boolean optimizedMessageDispatch = true;
    private boolean copyMessageOnSend = true;
    private boolean useCompression = false;
    private boolean objectMessageSerializationDefered = false;
    protected boolean asyncDispatch = false;
    protected boolean alwaysSessionAsync = true;
    private boolean useAsyncSend = false;
    private boolean optimizeAcknowledge = true;
    private int closeTimeout = 15000;
    private boolean useRetroactiveConsumer;
    JMSStatsImpl factoryStats = new JMSStatsImpl();
    protected static final Executor DEFAULT_CONNECTION_EXECUTOR = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

        public Thread newThread(Runnable run) {
            Thread thread = new Thread(run);
            thread.setPriority(7);
            return thread;
        }
    });

    public ActiveMQConnectionFactory() {
        this(DEFAULT_BROKER_URL);
    }

    public ActiveMQConnectionFactory(String brokerURL) {
        this(ActiveMQConnectionFactory.createURI(brokerURL));
    }

    public ActiveMQConnectionFactory copy() {
        try {
            return (ActiveMQConnectionFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This should never happen: " + e, e);
        }
    }

    private static URI createURI(String brokerURL) {
        try {
            return new URI(brokerURL);
        }
        catch (URISyntaxException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Invalid broker URI: " + brokerURL).initCause(e);
        }
    }

    public ActiveMQConnectionFactory(URI brokerURL) {
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, URI brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL.toString());
    }

    public ActiveMQConnectionFactory(String userName, String password, String brokerURL) {
        this.setUserName(userName);
        this.setPassword(password);
        this.setBrokerURL(brokerURL);
    }

    public Connection createConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createActiveMQConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createActiveMQConnection(userName, password);
    }

    public StatsImpl getStats() {
        return null;
    }

    protected ActiveMQConnection createActiveMQConnection() throws JMSException {
        return this.createActiveMQConnection(this.userName, this.password);
    }

    protected ActiveMQConnection createActiveMQConnection(String userName, String password) throws JMSException {
        if (this.brokerURL == null) {
            throw new ConfigurationException("brokerURL not set.");
        }
        try {
            Transport transport = TransportFactory.connect(this.brokerURL, DEFAULT_CONNECTION_EXECUTOR);
            ActiveMQConnection connection = this.createActiveMQConnection(transport, this.factoryStats);
            connection.setUserName(userName);
            connection.setPassword(password);
            connection.setPrefetchPolicy(this.getPrefetchPolicy());
            connection.setDisableTimeStampsByDefault(this.isDisableTimeStampsByDefault());
            connection.setOnSendPrepareMessageBody(this.isOnSendPrepareMessageBody());
            connection.setOptimizedMessageDispatch(this.isOptimizedMessageDispatch());
            connection.setCopyMessageOnSend(this.isCopyMessageOnSend());
            connection.setUseCompression(this.isUseCompression());
            connection.setObjectMessageSerializationDefered(this.isObjectMessageSerializationDefered());
            connection.setAsyncDispatch(this.isAsyncDispatch());
            connection.setUseAsyncSend(this.isUseAsyncSend());
            connection.setAlwaysSessionAsync(this.isAlwaysSessionAsync());
            connection.setOptimizeAcknowledge(this.isOptimizeAcknowledge());
            connection.setUseRetroactiveConsumer(this.isUseRetroactiveConsumer());
            connection.setRedeliveryPolicy(this.getRedeliveryPolicy());
            transport.start();
            if (this.clientID != null) {
                connection.setClientID(this.clientID);
            }
            return connection;
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Could not connect to broker URL: " + this.brokerURL + ". Reason: " + e, e);
        }
    }

    protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        ActiveMQConnection connection = new ActiveMQConnection(transport, stats);
        return connection;
    }

    public String getBrokerURL() {
        return this.brokerURL == null ? null : this.brokerURL.toString();
    }

    public void setBrokerURL(String brokerURL) {
        this.brokerURL = ActiveMQConnectionFactory.createURI(brokerURL);
        if (this.brokerURL.getQuery() != null) {
            try {
                Map map = URISupport.parseQuery(this.brokerURL.getQuery());
                if (IntrospectionSupport.setProperties(this, map, "jms.")) {
                    this.brokerURL = URISupport.createRemainingURI(this.brokerURL, map);
                }
            }
            catch (URISyntaxException e) {}
        } else {
            try {
                URISupport.CompositeData data = URISupport.parseComposite(this.brokerURL);
                if (IntrospectionSupport.setProperties(this, data.getParameters(), "jms.")) {
                    this.brokerURL = data.toURI();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean optimizedMessageDispatch) {
        this.optimizedMessageDispatch = optimizedMessageDispatch;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isUseRetroactiveConsumer() {
        return this.useRetroactiveConsumer;
    }

    public void setUseRetroactiveConsumer(boolean useRetroactiveConsumer) {
        this.useRetroactiveConsumer = useRetroactiveConsumer;
    }

    public RedeliveryPolicy getRedeliveryPolicy() {
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public void buildFromProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        IntrospectionSupport.setProperties(this, properties);
        String temp = properties.getProperty("java.naming.provider.url");
        if (temp == null || temp.length() == 0) {
            temp = properties.getProperty("brokerURL");
        }
        if (temp != null && temp.length() > 0) {
            this.setBrokerURL(temp);
        }
    }

    public void populateProperties(Properties props) {
        props.setProperty("asyncDispatch", Boolean.toString(this.isAsyncDispatch()));
        props.setProperty("java.naming.provider.url", this.getBrokerURL());
        props.setProperty("brokerURL", this.getBrokerURL());
        if (this.getClientID() != null) {
            props.setProperty("clientID", this.getClientID());
        }
        props.setProperty("copyMessageOnSend", Boolean.toString(this.isCopyMessageOnSend()));
        props.setProperty("disableTimeStampsByDefault", Boolean.toString(this.isDisableTimeStampsByDefault()));
        props.setProperty("objectMessageSerializationDefered", Boolean.toString(this.isObjectMessageSerializationDefered()));
        props.setProperty("onSendPrepareMessageBody", Boolean.toString(this.isOnSendPrepareMessageBody()));
        props.setProperty("optimizedMessageDispatch", Boolean.toString(this.isOptimizedMessageDispatch()));
        props.setProperty("password", this.getPassword());
        props.setProperty("useAsyncSend", Boolean.toString(this.isUseAsyncSend()));
        props.setProperty("useCompression", Boolean.toString(this.isUseCompression()));
        props.setProperty("useRetroactiveConsumer", Boolean.toString(this.isUseRetroactiveConsumer()));
        props.setProperty("userName", this.getUserName());
        props.setProperty("closeTimeout", Integer.toString(this.getCloseTimeout()));
        props.setProperty("alwaysSessionAsync", Boolean.toString(this.isAlwaysSessionAsync()));
        props.setProperty("optimizeAcknowledge", Boolean.toString(this.isOptimizeAcknowledge()));
    }

    public boolean isOnSendPrepareMessageBody() {
        return this.onSendPrepareMessageBody;
    }

    public void setOnSendPrepareMessageBody(boolean onSendPrepareMessageBody) {
        this.onSendPrepareMessageBody = onSendPrepareMessageBody;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isObjectMessageSerializationDefered() {
        return this.objectMessageSerializationDefered;
    }

    public void setObjectMessageSerializationDefered(boolean objectMessageSerializationDefered) {
        this.objectMessageSerializationDefered = objectMessageSerializationDefered;
    }

    public boolean isAsyncDispatch() {
        return this.asyncDispatch;
    }

    public void setAsyncDispatch(boolean asyncDispatch) {
        this.asyncDispatch = asyncDispatch;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public boolean isAlwaysSessionAsync() {
        return this.alwaysSessionAsync;
    }

    public void setAlwaysSessionAsync(boolean alwaysSessionAsync) {
        this.alwaysSessionAsync = alwaysSessionAsync;
    }

    public boolean isOptimizeAcknowledge() {
        return this.optimizeAcknowledge;
    }

    public void setOptimizeAcknowledge(boolean optimizeAcknowledge) {
        this.optimizeAcknowledge = optimizeAcknowledge;
    }
}

