/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;

public class BrokerView
implements BrokerViewMBean {
    final ManagedRegionBroker broker;
    private final BrokerService brokerService;

    public BrokerView(BrokerService brokerService, ManagedRegionBroker managedBroker) throws Exception {
        this.brokerService = brokerService;
        this.broker = managedBroker;
    }

    public ManagedRegionBroker getBroker() {
        return this.broker;
    }

    public String getBrokerId() {
        return this.broker.getBrokerId().toString();
    }

    public void gc() throws Exception {
        this.brokerService.getBroker().gc();
    }

    public void start() throws Exception {
        this.brokerService.start();
    }

    public void stop() throws Exception {
        this.brokerService.stop();
    }

    public long getTotalEnqueueCount() {
        return this.broker.getDestinationStatistics().getEnqueues().getCount();
    }

    public long getTotalDequeueCount() {
        return this.broker.getDestinationStatistics().getDequeues().getCount();
    }

    public long getTotalConsumerCount() {
        return this.broker.getDestinationStatistics().getConsumers().getCount();
    }

    public long getTotalMessageCount() {
        return this.broker.getDestinationStatistics().getMessages().getCount();
    }

    public long getTotalMessagesCached() {
        return this.broker.getDestinationStatistics().getMessagesCached().getCount();
    }

    public int getMemoryPercentageUsed() {
        return this.brokerService.getMemoryManager().getPercentUsage();
    }

    public long getMemoryLimit() {
        return this.brokerService.getMemoryManager().getLimit();
    }

    public void setMemoryLimit(long limit) {
        this.brokerService.getMemoryManager().setLimit(limit);
    }

    public void resetStatistics() {
        this.broker.getDestinationStatistics().reset();
    }

    public void terminateJVM(int exitCode) {
        System.exit(exitCode);
    }

    public ObjectName[] getTopics() {
        return this.broker.getTopics();
    }

    public ObjectName[] getQueues() {
        return this.broker.getQueues();
    }

    public ObjectName[] getTemporaryTopics() {
        return this.broker.getTemporaryTopics();
    }

    public ObjectName[] getTemporaryQueues() {
        return this.broker.getTemporaryQueues();
    }

    public ObjectName[] getTopicSubscribers() {
        return this.broker.getTemporaryTopicSubscribers();
    }

    public ObjectName[] getDurableTopicSubscribers() {
        return this.broker.getDurableTopicSubscribers();
    }

    public ObjectName[] getQueueSubscribers() {
        return this.broker.getQueueSubscribers();
    }

    public ObjectName[] getTemporaryTopicSubscribers() {
        return this.broker.getTemporaryTopicSubscribers();
    }

    public ObjectName[] getTemporaryQueueSubscribers() {
        return this.broker.getTemporaryQueueSubscribers();
    }

    public ObjectName[] getInactiveDurableTopicSubscribers() {
        return this.broker.getInactiveDurableTopicSubscribers();
    }

    public void addTopic(String name) throws Exception {
        this.broker.addDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQTopic(name));
    }

    public void addQueue(String name) throws Exception {
        this.broker.addDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQQueue(name));
    }

    public void removeTopic(String name) throws Exception {
        this.broker.removeDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQTopic(name), 1000L);
    }

    public void removeQueue(String name) throws Exception {
        this.broker.removeDestination(BrokerView.getConnectionContext(this.broker.getContextBroker()), new ActiveMQQueue(name), 1000L);
    }

    public ObjectName createDurableSubscriber(String clientId, String subscriberName, String topicName, String selector) throws Exception {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(clientId);
        ConsumerInfo info = new ConsumerInfo();
        ConsumerId consumerId = new ConsumerId();
        consumerId.setConnectionId(clientId);
        consumerId.setSessionId(0L);
        consumerId.setValue(0L);
        info.setConsumerId(consumerId);
        info.setDestination(new ActiveMQTopic(topicName));
        info.setSubcriptionName(subscriberName);
        info.setSelector(selector);
        Subscription subscription = this.broker.addConsumer(context, info);
        this.broker.removeConsumer(context, info);
        if (subscription != null) {
            return subscription.getObjectName();
        }
        return null;
    }

    public void destroyDurableSubscriber(String clientId, String subscriberName) throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(clientId);
        info.setSubcriptionName(subscriberName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(this.broker);
        context.setClientId(clientId);
        this.broker.removeSubscription(context, info);
    }

    public static ConnectionContext getConnectionContext(Broker broker) {
        ConnectionContext context = new ConnectionContext();
        context.setBroker(broker);
        return context;
    }
}

