/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.jmx.OpenTypeSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;

public class DestinationView {
    protected final org.apache.activemq.broker.region.Destination destination;
    protected final ManagedRegionBroker broker;

    public DestinationView(ManagedRegionBroker broker, org.apache.activemq.broker.region.Destination destination) {
        this.broker = broker;
        this.destination = destination;
    }

    public void gc() {
        this.destination.gc();
    }

    public String getName() {
        return this.destination.getName();
    }

    public void resetStatistics() {
        this.destination.resetStatistics();
    }

    public long getEnqueueCount() {
        return this.destination.getEnqueueCount();
    }

    public long getDequeueCount() {
        return this.destination.getDequeueCount();
    }

    public long getConsumerCount() {
        return this.destination.getConsumerCount();
    }

    public long getQueueSize() {
        return this.destination.getQueueSize();
    }

    public long getMessagesCached() {
        return this.destination.getMessagesCached();
    }

    public int getMemoryPercentageUsed() {
        return this.destination.getMemoryPercentageUsed();
    }

    public long getMemoryLimit() {
        return this.destination.getMemoryLimit();
    }

    public void setMemoryLimit(long limit) {
        this.destination.setMemoryLimit(limit);
    }

    public CompositeData[] browse() throws OpenDataException {
        Message[] messages = this.destination.browse();
        CompositeData[] c = new CompositeData[messages.length];
        for (int i = 0; i < c.length; ++i) {
            try {
                c[i] = OpenTypeSupport.convert(messages[i]);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return c;
    }

    public TabularData browseAsTable() throws OpenDataException {
        OpenTypeSupport.OpenTypeFactory factory = OpenTypeSupport.getFactory(ActiveMQMessage.class);
        Message[] messages = this.destination.browse();
        CompositeType ct = factory.getCompositeType();
        TabularType tt = new TabularType("MessageList", "MessageList", ct, new String[]{"JMSMessageID"});
        TabularDataSupport rc = new TabularDataSupport(tt);
        for (int i = 0; i < messages.length; ++i) {
            rc.put(new CompositeDataSupport(ct, factory.getFields(messages[i])));
        }
        return rc;
    }

    public String sendTextMessage(String body) throws Exception {
        return this.sendTextMessage(Collections.EMPTY_MAP, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendTextMessage(Map headers, String body) throws Exception {
        String brokerUrl = "vm://" + this.broker.getBrokerName();
        ActiveMQDestination dest = this.destination.getActiveMQDestination();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(brokerUrl);
        Connection connection = null;
        try {
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)dest);
            ActiveMQTextMessage msg = (ActiveMQTextMessage)session.createTextMessage(body);
            Iterator iter = headers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                msg.setObjectProperty((String)entry.getKey(), entry.getValue());
            }
            producer.setDeliveryMode(msg.getJMSDeliveryMode());
            producer.setPriority((int)msg.getPriority());
            long ttl = msg.getExpiration() - System.currentTimeMillis();
            producer.setTimeToLive(ttl > 0L ? ttl : 0L);
            producer.send((javax.jms.Message)msg);
            String string = msg.getJMSMessageID();
            return string;
        }
        finally {
            connection.close();
        }
    }
}

