/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Message;

public class OpenTypeSupport {
    private static final HashMap openTypeFactories = new HashMap();

    public static OpenTypeFactory getFactory(Class clazz) throws OpenDataException {
        return (OpenTypeFactory)openTypeFactories.get(clazz);
    }

    public static CompositeData convert(Message message) throws OpenDataException {
        OpenTypeFactory f = OpenTypeSupport.getFactory(message.getClass());
        if (f == null) {
            throw new OpenDataException("Cannot create a CompositeData for type: " + message.getClass().getName());
        }
        CompositeType ct = f.getCompositeType();
        Map fields = f.getFields(message);
        return new CompositeDataSupport(ct, fields);
    }

    static {
        openTypeFactories.put(ActiveMQMessage.class, new MessageOpenTypeFactory());
        openTypeFactories.put(ActiveMQBytesMessage.class, new ByteMessageOpenTypeFactory());
        openTypeFactories.put(ActiveMQMapMessage.class, new MapMessageOpenTypeFactory());
        openTypeFactories.put(ActiveMQObjectMessage.class, new ObjectMessageOpenTypeFactory());
        openTypeFactories.put(ActiveMQStreamMessage.class, new StreamMessageOpenTypeFactory());
        openTypeFactories.put(ActiveMQTextMessage.class, new TextMessageOpenTypeFactory());
    }

    static class TextMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        TextMessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQTextMessage == null ? (class$org$apache$activemq$command$ActiveMQTextMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQTextMessage")) : class$org$apache$activemq$command$ActiveMQTextMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
            this.addItem("Text", "Text", SimpleType.STRING);
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQTextMessage m = (ActiveMQTextMessage)o;
            Map rc = super.getFields(o);
            try {
                rc.put("Text", "" + m.getText());
            }
            catch (JMSException e) {
                rc.put("Text", "");
            }
            return rc;
        }
    }

    static class StreamMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        StreamMessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQStreamMessage == null ? (class$org$apache$activemq$command$ActiveMQStreamMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQStreamMessage")) : class$org$apache$activemq$command$ActiveMQStreamMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQStreamMessage m = (ActiveMQStreamMessage)o;
            Map rc = super.getFields(o);
            return rc;
        }
    }

    static class ObjectMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ObjectMessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQObjectMessage == null ? (class$org$apache$activemq$command$ActiveMQObjectMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQObjectMessage")) : class$org$apache$activemq$command$ActiveMQObjectMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQObjectMessage m = (ActiveMQObjectMessage)o;
            Map rc = super.getFields(o);
            return rc;
        }
    }

    static class MapMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        MapMessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQMapMessage == null ? (class$org$apache$activemq$command$ActiveMQMapMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQMapMessage")) : class$org$apache$activemq$command$ActiveMQMapMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
            this.addItem("ContentMap", "Content map", SimpleType.STRING);
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQMapMessage m = (ActiveMQMapMessage)o;
            Map rc = super.getFields(o);
            long length = 0L;
            try {
                rc.put("ContentMap", "" + m.getContentMap());
            }
            catch (JMSException e) {
                rc.put("ContentMap", "");
            }
            return rc;
        }
    }

    static class ByteMessageOpenTypeFactory
    extends MessageOpenTypeFactory {
        ByteMessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQBytesMessage == null ? (class$org$apache$activemq$command$ActiveMQBytesMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQBytesMessage")) : class$org$apache$activemq$command$ActiveMQBytesMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
            this.addItem("BodyLength", "Body length", SimpleType.LONG);
            this.addItem("BodyPreview", "Body preview", new ArrayType(1, SimpleType.BYTE));
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQBytesMessage m = (ActiveMQBytesMessage)o;
            Map rc = super.getFields(o);
            long length = 0L;
            try {
                length = m.getBodyLength();
                rc.put("BodyLength", new Long(length));
            }
            catch (JMSException e) {
                rc.put("BodyLength", new Long(0L));
            }
            try {
                byte[] preview = new byte[(int)Math.min(length, 255L)];
                m.readBytes(preview);
                rc.put("BodyPreview", preview);
            }
            catch (JMSException e) {
                rc.put("BodyPreview", new byte[0]);
            }
            return rc;
        }
    }

    static class MessageOpenTypeFactory
    extends AbstractOpenTypeFactory {
        MessageOpenTypeFactory() {
        }

        protected String getTypeName() {
            return (class$org$apache$activemq$command$ActiveMQMessage == null ? (class$org$apache$activemq$command$ActiveMQMessage = OpenTypeSupport.class$("org.apache.activemq.command.ActiveMQMessage")) : class$org$apache$activemq$command$ActiveMQMessage).getName();
        }

        protected void init() throws OpenDataException {
            super.init();
            this.addItem("JMSCorrelationID", "JMSCorrelationID", SimpleType.STRING);
            this.addItem("JMSDestination", "JMSDestination", SimpleType.STRING);
            this.addItem("JMSMessageID", "JMSMessageID", SimpleType.STRING);
            this.addItem("JMSReplyTo", "JMSReplyTo", SimpleType.STRING);
            this.addItem("JMSType", "JMSType", SimpleType.STRING);
            this.addItem("JMSDeliveryMode", "JMSDeliveryMode", SimpleType.STRING);
            this.addItem("JMSExpiration", "JMSExpiration", SimpleType.LONG);
            this.addItem("JMSPriority", "JMSPriority", SimpleType.INTEGER);
            this.addItem("JMSRedelivered", "JMSRedelivered", SimpleType.BOOLEAN);
            this.addItem("JMSTimestamp", "JMSTimestamp", SimpleType.DATE);
            this.addItem("Properties", "Properties", SimpleType.STRING);
        }

        public Map getFields(Object o) throws OpenDataException {
            ActiveMQMessage m = (ActiveMQMessage)o;
            Map rc = super.getFields(o);
            rc.put("JMSCorrelationID", m.getJMSCorrelationID());
            rc.put("JMSDestination", "" + m.getJMSDestination());
            rc.put("JMSMessageID", m.getJMSMessageID());
            rc.put("JMSReplyTo", "" + m.getJMSReplyTo());
            rc.put("JMSType", m.getJMSType());
            rc.put("JMSDeliveryMode", m.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON-PERSISTENT");
            rc.put("JMSExpiration", new Long(m.getJMSExpiration()));
            rc.put("JMSPriority", new Integer(m.getJMSPriority()));
            rc.put("JMSRedelivered", new Boolean(m.getJMSRedelivered()));
            rc.put("JMSTimestamp", new Date(m.getJMSTimestamp()));
            try {
                rc.put("Properties", "" + m.getProperties());
            }
            catch (IOException e) {
                rc.put("Properties", "");
            }
            return rc;
        }
    }

    static abstract class AbstractOpenTypeFactory
    implements OpenTypeFactory {
        private CompositeType compositeType;
        ArrayList itemNamesList = new ArrayList();
        ArrayList itemDescriptionsList = new ArrayList();
        ArrayList itemTypesList = new ArrayList();

        AbstractOpenTypeFactory() {
        }

        public CompositeType getCompositeType() throws OpenDataException {
            if (this.compositeType == null) {
                this.init();
                this.compositeType = this.createCompositeType();
            }
            return this.compositeType;
        }

        protected void init() throws OpenDataException {
        }

        protected CompositeType createCompositeType() throws OpenDataException {
            String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
            String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
            OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
            return new CompositeType(this.getTypeName(), this.getDescription(), itemNames, itemDescriptions, itemTypes);
        }

        protected abstract String getTypeName();

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected String getDescription() {
            return this.getTypeName();
        }

        public Map getFields(Object o) throws OpenDataException {
            HashMap rc = new HashMap();
            return rc;
        }
    }

    static interface OpenTypeFactory {
        public CompositeType getCompositeType() throws OpenDataException;

        public Map getFields(Object var1) throws OpenDataException;
    }
}

