/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRegion
implements Region {
    private static final Log log = LogFactory.getLog((Class)AbstractRegion.class);
    protected final ConcurrentHashMap destinations = new ConcurrentHashMap();
    protected final DestinationMap destinationMap = new DestinationMap();
    protected final ConcurrentHashMap subscriptions = new ConcurrentHashMap();
    protected final UsageManager memoryManager;
    protected final PersistenceAdapter persistenceAdapter;
    protected final DestinationStatistics destinationStatistics;
    protected final RegionBroker broker;
    protected boolean autoCreateDestinations = true;
    protected final TaskRunnerFactory taskRunnerFactory;
    protected final Object destinationsMutex = new Object();

    public AbstractRegion(RegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        this.broker = broker;
        this.destinationStatistics = destinationStatistics;
        this.memoryManager = memoryManager;
        this.taskRunnerFactory = taskRunnerFactory;
        this.persistenceAdapter = persistenceAdapter;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        log.debug((Object)("Adding destination: " + destination));
        Destination dest = this.createDestination(context, destination);
        dest.start();
        Object object = this.destinationsMutex;
        synchronized (object) {
            this.destinations.put((Object)destination, (Object)dest);
            this.destinationMap.put(destination, dest);
            Iterator iter = this.subscriptions.values().iterator();
            while (iter.hasNext()) {
                Subscription sub = (Subscription)iter.next();
                if (!sub.matches(destination)) continue;
                dest.addSubscription(context, sub);
            }
            return dest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (timeout == 0L) {
            Iterator iter = this.subscriptions.values().iterator();
            while (iter.hasNext()) {
                Subscription sub = (Subscription)iter.next();
                if (!sub.matches(destination)) continue;
                throw new JMSException("Destination still has an active subscription: " + destination);
            }
        }
        if (timeout > 0L) {
            // empty if block
        }
        log.debug((Object)("Removing destination: " + destination));
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.remove((Object)destination);
            if (dest != null) {
                Iterator iter = this.subscriptions.values().iterator();
                while (iter.hasNext()) {
                    Subscription sub = (Subscription)iter.next();
                    if (!sub.matches(destination)) continue;
                    dest.removeSubscription(context, sub);
                }
                this.destinationMap.removeAll(destination);
                dest.dispose(context);
                dest.stop();
            } else {
                log.debug((Object)("Destination doesn't exist: " + dest));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDestinationMap() {
        Object object = this.destinationsMutex;
        synchronized (object) {
            return new HashMap(this.destinations);
        }
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription sub = this.createSubscription(context, info);
        if (this.persistenceAdapter != null) {
            Set inactiveDests = this.getInactiveDestinations();
            Iterator iter = inactiveDests.iterator();
            while (iter.hasNext()) {
                ActiveMQDestination dest = (ActiveMQDestination)iter.next();
                if (!sub.matches(dest)) continue;
                context.getBroker().addDestination(context, dest);
            }
        }
        this.subscriptions.put((Object)info.getConsumerId(), (Object)sub);
        Iterator iter = this.destinationMap.get(info.getDestination()).iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.addSubscription(context, sub);
        }
        if (info.isBrowser()) {
            ((QueueBrowserSubscription)sub).browseDone();
        }
        return sub;
    }

    public Set getDurableDestinations() {
        return this.persistenceAdapter.getDestinations();
    }

    protected Set getInactiveDestinations() {
        Set inactiveDests = this.persistenceAdapter.getDestinations();
        inactiveDests.removeAll(this.destinations.keySet());
        return inactiveDests;
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.remove((Object)info.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + info.getConsumerId());
        }
        Iterator iter = this.destinationMap.get(info.getDestination()).iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.removeSubscription(context, sub);
        }
        this.destroySubscription(sub);
    }

    protected void destroySubscription(Subscription sub) {
        sub.destroy();
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        throw new JMSException("Invalid operation.");
    }

    public void send(ConnectionContext context, Message messageSend) throws Exception {
        Destination dest = this.lookup(context, messageSend.getDestination());
        dest.send(context, messageSend);
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.get((Object)ack.getConsumerId());
        if (sub == null) {
            throw new IllegalArgumentException("The subscription does not exist: " + ack.getConsumerId());
        }
        sub.acknowledge(context, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Destination lookup(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        Object object = this.destinationsMutex;
        synchronized (object) {
            Destination dest = (Destination)this.destinations.get((Object)destination);
            if (dest == null) {
                if (this.autoCreateDestinations) {
                    context.getBroker().addDestination(context, destination);
                    dest = (Destination)this.destinations.get((Object)destination);
                }
                if (dest == null) {
                    throw new JMSException("The destination " + destination + " does not exist.");
                }
            }
            return dest;
        }
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        Subscription sub = (Subscription)this.subscriptions.get((Object)messageDispatchNotification.getConsumerId());
        if (sub != null) {
            sub.processMessageDispatchNotification(messageDispatchNotification);
        }
    }

    public void gc() {
        Iterator iter = this.subscriptions.values().iterator();
        while (iter.hasNext()) {
            Subscription sub = (Subscription)iter.next();
            sub.gc();
        }
        iter = this.destinations.values().iterator();
        while (iter.hasNext()) {
            Destination dest = (Destination)iter.next();
            dest.gc();
        }
    }

    protected abstract Subscription createSubscription(ConnectionContext var1, ConsumerInfo var2) throws Exception;

    protected abstract Destination createDestination(ConnectionContext var1, ActiveMQDestination var2) throws Exception;

    public boolean isAutoCreateDestinations() {
        return this.autoCreateDestinations;
    }

    public void setAutoCreateDestinations(boolean autoCreateDestinations) {
        this.autoCreateDestinations = autoCreateDestinations;
    }
}

