/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PrefetchSubscription
extends AbstractSubscription {
    private static final Log log = LogFactory.getLog((Class)PrefetchSubscription.class);
    protected final LinkedList pending = new LinkedList();
    protected final LinkedList dispatched = new LinkedList();
    protected int prefetchExtension = 0;
    boolean dispatching = false;
    long enqueueCounter;
    long dispatchCounter;
    long dequeueCounter;

    public PrefetchSubscription(Broker broker, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, context, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(MessageReference node) throws Exception {
        ++this.enqueueCounter;
        if (!this.isFull()) {
            this.dispatch(node);
        } else {
            this.optimizePrefetch();
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                if (this.pending.isEmpty()) {
                    log.debug((Object)"Prefetch limit.");
                }
                this.pending.addLast(node);
            }
        }
    }

    public synchronized void processMessageDispatchNotification(MessageDispatchNotification mdn) throws Exception {
        LinkedList linkedList = this.pending;
        synchronized (linkedList) {
            Iterator i = this.pending.iterator();
            while (i.hasNext()) {
                MessageReference node = (MessageReference)i.next();
                if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                i.remove();
                this.createMessageDispatch(node, node.getMessage());
                this.dispatched.addLast(node);
                return;
            }
            throw new JMSException("Slave broker out of sync with master: Dispatched message (" + mdn.getMessageId() + ") was not in the pending list: " + this.pending);
        }
    }

    public synchronized void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        if (ack.isStandardAck()) {
            int index = 0;
            boolean inAckRange = false;
            Iterator iter = this.dispatched.iterator();
            while (iter.hasNext()) {
                final MessageReference node = (MessageReference)iter.next();
                MessageId messageId = node.getMessageId();
                if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                    inAckRange = true;
                }
                if (!inAckRange) continue;
                if (!context.isInTransaction()) {
                    ++this.dequeueCounter;
                    iter.remove();
                } else {
                    context.getTransaction().addSynchronization(new Synchronization(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void afterCommit() throws Exception {
                            PrefetchSubscription prefetchSubscription = PrefetchSubscription.this;
                            synchronized (prefetchSubscription) {
                                ++PrefetchSubscription.this.dequeueCounter;
                                PrefetchSubscription.this.dispatched.remove(node);
                                --PrefetchSubscription.this.prefetchExtension;
                            }
                        }
                    });
                }
                ++index;
                this.acknowledge(context, ack, node);
                if (!ack.getLastMessageId().equals(messageId)) continue;
                this.prefetchExtension = context.isInTransaction() ? Math.max(this.prefetchExtension, index + 1) : Math.max(0, this.prefetchExtension - (index + 1));
                this.dispatchMatched();
                return;
            }
            log.info((Object)("Could not correlate acknowledgment with dispatched message: " + ack));
        } else {
            if (ack.isDeliveredAck()) {
                int index = 0;
                Iterator iter = this.dispatched.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    if (ack.getLastMessageId().equals(node.getMessageId())) {
                        this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                        this.dispatchMatched();
                        return;
                    }
                    ++index;
                }
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
            if (ack.isPoisonAck()) {
                if (ack.isInTransaction()) {
                    throw new JMSException("Poison ack cannot be transacted: " + ack);
                }
                int index = 0;
                boolean inAckRange = false;
                Iterator iter = this.dispatched.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    this.sendToDLQ(context, node);
                    iter.remove();
                    ++this.dequeueCounter;
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                    this.dispatchMatched();
                    return;
                }
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
        }
        if (this.isSlaveBroker()) {
            throw new JMSException("Slave broker out of sync with master: Acknowledgment (" + ack + ") was not in the dispatch list: " + this.dispatched);
        }
        throw new JMSException("Invalid acknowledgment: " + ack);
    }

    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        Message message = node.getMessage();
        if (message != null) {
            DeadLetterStrategy deadLetterStrategy = node.getRegionDestination().getDeadLetterStrategy();
            ActiveMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message.getDestination());
            BrokerSupport.resend(context, message, deadLetterDestination);
        }
    }

    protected boolean isFull() {
        return this.isSlaveBroker() || this.dispatched.size() - this.prefetchExtension >= this.info.getPrefetchSize();
    }

    public boolean isLowWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    public boolean isHighWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingQueueSize() {
        LinkedList linkedList = this.pending;
        synchronized (linkedList) {
            return this.pending.size();
        }
    }

    public synchronized int getDispatchedQueueSize() {
        return this.dispatched.size();
    }

    public synchronized long getDequeueCounter() {
        return this.dequeueCounter;
    }

    public synchronized long getDispatchedCounter() {
        return this.dispatchCounter;
    }

    public synchronized long getEnqueueCounter() {
        return this.enqueueCounter;
    }

    public void optimizePrefetch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchMatched() throws IOException {
        if (!this.dispatching) {
            this.dispatching = true;
            try {
                Iterator iter = this.pending.iterator();
                while (iter.hasNext() && !this.isFull()) {
                    MessageReference node = (MessageReference)iter.next();
                    iter.remove();
                    this.dispatch(node);
                }
            }
            finally {
                this.dispatching = false;
            }
        }
    }

    protected boolean dispatch(final MessageReference node) throws IOException {
        final Message message = node.getMessage();
        if (message == null) {
            return false;
        }
        if (this.canDispatch(node) && !this.isSlaveBroker()) {
            ++this.dispatchCounter;
            MessageDispatch md = this.createMessageDispatch(node, message);
            this.dispatched.addLast(node);
            if (this.info.isDispatchAsync()) {
                md.setConsumer(new Runnable(){

                    public void run() {
                        PrefetchSubscription.this.onDispatch(node, message);
                    }
                });
                this.context.getConnection().dispatchAsync(md);
            } else {
                this.context.getConnection().dispatchSync(md);
                this.onDispatch(node, message);
            }
            return true;
        }
        return false;
    }

    protected synchronized void onDispatch(MessageReference node, Message message) {
        if (node.getRegionDestination() != null) {
            node.getRegionDestination().getDestinationStatistics().onMessageDequeue(message);
            this.context.getConnection().getStatistics().onMessageDequeue(message);
            try {
                this.dispatchMatched();
            }
            catch (IOException e) {
                this.context.getConnection().serviceException(e);
            }
        }
    }

    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setDestination(node.getRegionDestination().getActiveMQDestination());
        md.setMessage(message);
        md.setRedeliveryCounter(node.getRedeliveryCounter());
        return md;
    }

    protected abstract boolean canDispatch(MessageReference var1) throws IOException;

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
    }
}

