/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.group.MessageGroupHashBucket;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupSet;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Queue
implements Destination {
    private final Log log;
    protected final ActiveMQDestination destination;
    protected final List consumers = new CopyOnWriteArrayList();
    private final LinkedList messages = new LinkedList();
    protected final Valve dispatchValve = new Valve(true);
    protected final UsageManager usageManager;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private LockOwner exclusiveOwner;
    private MessageGroupMap messageGroupOwners;
    private int messageGroupHashBucketCount = 1024;
    protected long garbageSize = 0L;
    protected long garbageSizeBeforeCollection = 1000L;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    protected final MessageStore store;
    protected int highestSubscriptionPriority;
    private DeadLetterStrategy deadLetterStrategy = new SharedDeadLetterStrategy();

    public Queue(ActiveMQDestination destination, UsageManager memoryManager, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        this.destination = destination;
        this.usageManager = new UsageManager(memoryManager);
        this.usageManager.setLimit(Long.MAX_VALUE);
        this.store = store;
        if (store != null) {
            store.setUsageManager(this.usageManager);
        }
        this.destinationStatistics.setParent(parentStats);
        this.log = LogFactory.getLog((String)(this.getClass().getName() + "." + destination.getPhysicalName()));
        if (store != null) {
            store.recover(new MessageRecoveryListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void recoverMessage(Message message) {
                    message.setRegionDestination(Queue.this);
                    MessageReference reference = Queue.this.createMessageReference(message);
                    LinkedList linkedList = Queue.this.messages;
                    synchronized (linkedList) {
                        Queue.this.messages.add(reference);
                    }
                    reference.decrementReferenceCount();
                    Queue.this.destinationStatistics.getMessages().increment();
                }

                public void recoverMessageReference(String messageReference) throws Exception {
                    throw new RuntimeException("Should not be called.");
                }

                public void finished() {
                }
            });
        }
    }

    public synchronized boolean lock(MessageReference node, LockOwner lockOwner) {
        if (this.exclusiveOwner == lockOwner) {
            return true;
        }
        if (this.exclusiveOwner != null) {
            return false;
        }
        if (lockOwner.getLockPriority() < this.highestSubscriptionPriority) {
            return false;
        }
        if (lockOwner.isLockExclusive()) {
            this.exclusiveOwner = lockOwner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        this.dispatchValve.turnOff();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            List list = this.consumers;
            synchronized (list) {
                this.consumers.add(sub);
            }
            this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
            msgContext.setDestination(this.destination);
            list = this.messages;
            synchronized (list) {
                Iterator iter = this.messages.iterator();
                while (iter.hasNext()) {
                    IndirectMessageReference node = (IndirectMessageReference)iter.next();
                    if (node.isDropped()) continue;
                    try {
                        msgContext.setMessageReference(node);
                        if (!sub.matches(node, msgContext)) continue;
                        sub.add(node);
                    }
                    catch (IOException e) {
                        this.log.warn((Object)("Could not load message: " + e), (Throwable)e);
                    }
                }
            }
        }
        finally {
            msgContext.clear();
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        block15: {
            this.destinationStatistics.getConsumers().decrement();
            this.dispatchValve.turnOff();
            try {
                List list = this.consumers;
                synchronized (list) {
                    this.consumers.remove(sub);
                }
                sub.remove(context, this);
                this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
                boolean wasExclusiveOwner = false;
                if (this.exclusiveOwner == sub) {
                    this.exclusiveOwner = null;
                    wasExclusiveOwner = true;
                }
                ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
                MessageGroupSet ownedGroups = this.getMessageGroupOwners().removeConsumer(consumerId);
                if (sub.getConsumerInfo().isBrowser()) break block15;
                MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
                try {
                    msgContext.setDestination(this.destination);
                    ArrayList<IndirectMessageReference> messagesToDispatch = new ArrayList<IndirectMessageReference>();
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        Iterator iter = this.messages.iterator();
                        while (iter.hasNext()) {
                            IndirectMessageReference node = (IndirectMessageReference)iter.next();
                            if (node.isDropped()) continue;
                            String groupID = node.getGroupID();
                            if (node.getLockOwner() != sub && !wasExclusiveOwner && (groupID == null || !ownedGroups.contains(groupID))) continue;
                            messagesToDispatch.add(node);
                        }
                    }
                    Iterator iter = messagesToDispatch.iterator();
                    while (iter.hasNext()) {
                        IndirectMessageReference node = (IndirectMessageReference)iter.next();
                        node.incrementRedeliveryCounter();
                        node.unlock();
                        msgContext.setMessageReference(node);
                        this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
                    }
                }
                finally {
                    msgContext.clear();
                }
            }
            finally {
                this.dispatchValve.turnOn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final ConnectionContext context, final Message message) throws Exception {
        if (context.isProducerFlowControl()) {
            this.usageManager.waitForSpace();
        }
        message.setRegionDestination(this);
        if (this.store != null && message.isPersistent()) {
            this.store.addMessage(context, message);
        }
        final MessageReference node = this.createMessageReference(message);
        try {
            if (context.isInTransaction()) {
                context.getTransaction().addSynchronization(new Synchronization(){

                    public void afterCommit() throws Exception {
                        Queue.this.dispatch(context, node, message);
                    }
                });
            } else {
                this.dispatch(context, node, message);
            }
        }
        finally {
            node.decrementReferenceCount();
        }
    }

    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
        this.destinationStatistics.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropEvent() {
        this.destinationStatistics.getMessages().decrement();
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            ++this.garbageSize;
            if (this.garbageSize > this.garbageSizeBeforeCollection) {
                this.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                IndirectMessageReference node = (IndirectMessageReference)iter.next();
                if (!node.isDropped()) continue;
                --this.garbageSize;
                iter.remove();
            }
        }
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            if (ack.getMessageCount() > 0) {
                MessageAck a = new MessageAck();
                ack.copy(a);
                ack = a;
                ack.setFirstMessageId(node.getMessageId());
                ack.setLastMessageId(node.getMessageId());
                ack.setMessageCount(1);
            }
            this.store.removeMessage(context, ack);
        }
    }

    public Message loadMessage(MessageId messageId) throws IOException {
        Message msg = this.store.getMessage(messageId);
        if (msg != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            size = this.messages.size();
        }
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.usageManager.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public String getDestination() {
        return this.destination.getPhysicalName();
    }

    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = new MessageGroupHashBucket(this.messageGroupHashBucketCount);
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public int getMessageGroupHashBucketCount() {
        return this.messageGroupHashBucketCount;
    }

    public void setMessageGroupHashBucketCount(int messageGroupHashBucketCount) {
        this.messageGroupHashBucketCount = messageGroupHashBucketCount;
    }

    public void resetStatistics() {
        this.getDestinationStatistics().reset();
    }

    public String getName() {
        return this.getActiveMQDestination().getPhysicalName();
    }

    public long getEnqueueCount() {
        return this.getDestinationStatistics().getEnqueues().getCount();
    }

    public long getDequeueCount() {
        return this.getDestinationStatistics().getDequeues().getCount();
    }

    public long getConsumerCount() {
        return this.getDestinationStatistics().getConsumers().getCount();
    }

    public long getQueueSize() {
        return this.getDestinationStatistics().getMessages().getCount();
    }

    public long getMessagesCached() {
        return this.getDestinationStatistics().getMessagesCached().getCount();
    }

    public int getMemoryPercentageUsed() {
        return this.getUsageManager().getPercentUsage();
    }

    public long getMemoryLimit() {
        return this.getUsageManager().getLimit();
    }

    public void setMemoryLimit(long limit) {
        this.getUsageManager().setLimit(limit);
    }

    private MessageReference createMessageReference(Message message) {
        return new IndirectMessageReference(this, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatch(ConnectionContext context, MessageReference node, Message message) throws Exception {
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            this.destinationStatistics.onMessageEnqueue(message);
            LinkedList linkedList = this.messages;
            synchronized (linkedList) {
                this.messages.add(node);
            }
            List list = this.consumers;
            synchronized (list) {
                if (this.consumers.isEmpty()) {
                    this.log.debug((Object)"No subscriptions registered, will not dispatch message at this time.");
                    return;
                }
            }
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(node);
            this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
            return;
        }
        finally {
            msgContext.clear();
            this.dispatchValve.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calcHighestSubscriptionPriority() {
        byte by;
        int n = Integer.MIN_VALUE;
        List list = this.consumers;
        synchronized (list) {
            Iterator iter = this.consumers.iterator();
            while (iter.hasNext()) {
                Subscription sub = (Subscription)iter.next();
                if (sub.getConsumerInfo().getPriority() <= by) continue;
                by = sub.getConsumerInfo().getPriority();
            }
        }
        return by;
    }

    public MessageStore getMessageStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] browse() {
        ArrayList<Message> l = new ArrayList<Message>();
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                try {
                    MessageReference r = (MessageReference)iter.next();
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        if (m == null) continue;
                        l.add(m);
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                catch (IOException e) {}
            }
        }
        return l.toArray(new Message[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(String messageId) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            ConnectionContext c = new ConnectionContext();
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                try {
                    IndirectMessageReference r = (IndirectMessageReference)iter.next();
                    if (!messageId.equals(r.getMessageId().toString()) || !r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER)) continue;
                    MessageAck ack = new MessageAck();
                    ack.setAckType((byte)2);
                    ack.setDestination(this.destination);
                    ack.setMessageID(r.getMessageId());
                    this.acknowledge(c, null, ack, r);
                    r.drop();
                    this.dropEvent();
                    iter.remove();
                    return true;
                }
                catch (IOException e) {
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message getMessage(String messageId) {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                try {
                    MessageReference r = (MessageReference)iter.next();
                    if (!messageId.equals(r.getMessageId().toString())) continue;
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        if (m == null) return null;
                        Message message = m;
                        return message;
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                catch (IOException e) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            ConnectionContext c = new ConnectionContext();
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                try {
                    IndirectMessageReference r = (IndirectMessageReference)iter.next();
                    if (!r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER)) continue;
                    MessageAck ack = new MessageAck();
                    ack.setAckType((byte)2);
                    ack.setDestination(this.destination);
                    ack.setMessageID(r.getMessageId());
                    this.acknowledge(c, null, ack, r);
                    r.drop();
                    this.dropEvent();
                    iter.remove();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                try {
                    MessageReference r = (MessageReference)iter.next();
                    if (!messageId.equals(r.getMessageId().toString())) continue;
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        BrokerSupport.resend(context, m, dest);
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                    return true;
                }
                catch (IOException e) {
                }
            }
        }
        return false;
    }
}

