/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueSubscription;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.filter.MessageEvaluationContext;

public class QueueBrowserSubscription
extends QueueSubscription {
    boolean browseDone;

    public QueueBrowserSubscription(Broker broker, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, context, info);
    }

    protected boolean canDispatch(MessageReference node) {
        return !((IndirectMessageReference)node).isAcked();
    }

    public String toString() {
        return "QueueBrowserSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize();
    }

    public void browseDone() throws Exception {
        this.browseDone = true;
        this.add(IndirectMessageReference.END_OF_BROWSE_MARKER);
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        if (node == IndirectMessageReference.END_OF_BROWSE_MARKER) {
            MessageDispatch md = new MessageDispatch();
            md.setMessage(null);
            md.setConsumerId(this.info.getConsumerId());
            md.setDestination(null);
            return md;
        }
        return super.createMessageDispatch(node, message);
    }

    public boolean matches(MessageReference node, MessageEvaluationContext context) throws IOException {
        return !this.browseDone && super.matches(node, context);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
    }
}

