/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractRegion;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.QueueBrowserSubscription;
import org.apache.activemq.broker.region.QueueSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;

public class QueueRegion
extends AbstractRegion {
    public QueueRegion(RegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, persistenceAdapter);
    }

    public String toString() {
        return "QueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }

    protected Destination createDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        MessageStore store = this.persistenceAdapter.createQueueMessageStore((ActiveMQQueue)destination);
        Queue queue = new Queue(destination, this.memoryManager, store, this.destinationStatistics, this.taskRunnerFactory);
        this.configureQueue(queue, destination);
        return queue;
    }

    protected void configureQueue(Queue queue, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure(queue);
        }
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        if (info.isBrowser()) {
            return new QueueBrowserSubscription(this.broker, context, info);
        }
        return new QueueSubscription(this.broker, context, info);
    }

    protected Set getInactiveDestinations() {
        Set inactiveDestinations = super.getInactiveDestinations();
        Iterator iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)iter.next();
            if (dest.isQueue()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }
}

