/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.transaction.Synchronization;

public class QueueSubscription
extends PrefetchSubscription
implements LockOwner {
    public QueueSubscription(Broker broker, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        super(broker, context, info);
    }

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference n) throws IOException {
        final IndirectMessageReference node = (IndirectMessageReference)n;
        final Queue queue = (Queue)node.getRegionDestination();
        queue.acknowledge(context, this, ack, node);
        if (!ack.isInTransaction()) {
            node.drop();
            queue.dropEvent();
        } else {
            node.setAcked(true);
            context.getTransaction().addSynchronization(new Synchronization(){

                public void afterCommit() throws Exception {
                    node.drop();
                    queue.dropEvent();
                }

                public void afterRollback() throws Exception {
                    node.setAcked(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canDispatch(MessageReference n) throws IOException {
        IndirectMessageReference node = (IndirectMessageReference)n;
        if (node.isAcked()) {
            return false;
        }
        String groupId = node.getGroupID();
        int sequence = node.getGroupSequence();
        if (groupId != null) {
            ConsumerId groupOwner;
            MessageGroupMap messageGroupOwners = ((Queue)node.getRegionDestination()).getMessageGroupOwners();
            if (sequence == 1) {
                if (node.lock(this)) {
                    messageGroupOwners.put(groupId, this.info.getConsumerId());
                    return true;
                }
                return false;
            }
            IndirectMessageReference indirectMessageReference = node;
            synchronized (indirectMessageReference) {
                groupOwner = messageGroupOwners.get(groupId);
                if (groupOwner == null) {
                    if (node.lock(this)) {
                        messageGroupOwners.put(groupId, this.info.getConsumerId());
                        return true;
                    }
                    return false;
                }
            }
            if (groupOwner.equals(this.info.getConsumerId())) {
                if (sequence < 0) {
                    messageGroupOwners.removeGroup(groupId);
                }
                return true;
            }
            return false;
        }
        return node.lock(this);
    }

    public String toString() {
        return "QueueSubscription: consumer=" + this.info.getConsumerId() + ", destinations=" + this.destinations.size() + ", dispatched=" + this.dispatched.size() + ", delivered=" + this.prefetchExtension + ", pending=" + this.getPendingQueueSize();
    }

    public int getLockPriority() {
        return this.info.getPriority();
    }

    public boolean isLockExclusive() {
        return this.info.isExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatch(MessageReference node) throws IOException {
        boolean rc = false;
        node.incrementReferenceCount();
        try {
            rc = super.dispatch(node);
        }
        finally {
            if (!rc) {
                node.decrementReferenceCount();
            }
        }
        return rc;
    }

    protected void onDispatch(MessageReference node, Message message) {
        node.decrementReferenceCount();
        super.onDispatch(node, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        node.incrementReferenceCount();
        try {
            super.sendToDLQ(context, node);
        }
        finally {
            node.decrementReferenceCount();
        }
    }

    public synchronized void destroy() {
    }
}

