/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TempQueueRegion;
import org.apache.activemq.broker.region.TempTopicRegion;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;

public class RegionBroker
implements Broker {
    private static final IdGenerator brokerIdGenerator = new IdGenerator();
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    private BrokerService brokerService;
    private boolean stopped = false;
    private boolean keepDurableSubsActive = false;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private final CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    private final CopyOnWriteArraySet destinations = new CopyOnWriteArraySet();
    private final CopyOnWriteArrayList brokerInfos = new CopyOnWriteArrayList();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private Map clientIdSet = new HashMap();
    protected PersistenceAdapter adaptor;

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, PersistenceAdapter adapter) throws IOException {
        this.brokerService = brokerService;
        this.sequenceGenerator.setLastSequenceId(adapter.getLastMessageBrokerSequenceId());
        this.adaptor = adapter;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, adapter);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, adapter);
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory);
    }

    public Map getDestinationMap() {
        Map answer = this.getQueueRegion().getDestinationMap();
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    public Broker getAdaptor(Class type) {
        if (type.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTempQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new TempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, adapter);
    }

    protected Region createQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, adapter);
    }

    private static PersistenceAdapter createDefaultPersistenceAdapter(UsageManager memoryManager) throws IOException {
        return new MemoryPersistenceAdapter();
    }

    public void start() throws Exception {
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(this.keepDurableSubsActive);
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
    }

    public void stop() throws Exception {
        this.stopped = true;
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map map = this.clientIdSet;
        synchronized (map) {
            if (this.clientIdSet.containsKey(clientId)) {
                throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected");
            }
            this.clientIdSet.put(clientId, info);
        }
        this.connections.add((Object)context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        String clientId = info.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map map = this.clientIdSet;
        synchronized (map) {
            ConnectionInfo oldValue = (ConnectionInfo)this.clientIdSet.get(clientId);
            if (oldValue == info) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove((Object)context.getConnection());
    }

    public Connection[] getClients() throws Exception {
        ArrayList l = new ArrayList(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        if (this.destinations.contains((Object)destination)) {
            throw new JMSException("Destination already exists: " + destination);
        }
        Destination answer = null;
        switch (destination.getDestinationType()) {
            case 1: {
                answer = this.queueRegion.addDestination(context, destination);
                break;
            }
            case 2: {
                answer = this.topicRegion.addDestination(context, destination);
                break;
            }
            case 5: {
                answer = this.tempQueueRegion.addDestination(context, destination);
                break;
            }
            case 6: {
                answer = this.tempTopicRegion.addDestination(context, destination);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
        this.destinations.add((Object)destination);
        return answer;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (this.destinations.contains((Object)destination)) {
            switch (destination.getDestinationType()) {
                case 1: {
                    this.queueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 2: {
                    this.topicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 5: {
                    this.tempQueueRegion.removeDestination(context, destination, timeout);
                    break;
                }
                case 6: {
                    this.tempTopicRegion.removeDestination(context, destination, timeout);
                    break;
                }
                default: {
                    throw this.createUnknownDestinationTypeException(destination);
                }
            }
            this.destinations.remove((Object)destination);
        }
    }

    public void addDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.addDestination(context, info.getDestination());
    }

    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info) throws Exception {
        this.removeDestination(context, info.getDestination(), info.getTimeout());
    }

    public ActiveMQDestination[] getDestinations() throws Exception {
        ArrayList l = new ArrayList(this.destinations);
        ActiveMQDestination[] rc = new ActiveMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Exception {
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Exception {
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Exception {
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Exception {
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion.addConsumer(context, info);
            }
            case 2: {
                return this.topicRegion.addConsumer(context, info);
            }
            case 5: {
                return this.tempQueueRegion.addConsumer(context, info);
            }
            case 6: {
                return this.tempTopicRegion.addConsumer(context, info);
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.removeConsumer(context, info);
                break;
            }
            case 2: {
                this.topicRegion.removeConsumer(context, info);
                break;
            }
            case 5: {
                this.tempQueueRegion.removeConsumer(context, info);
                break;
            }
            case 6: {
                this.tempTopicRegion.removeConsumer(context, info);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        this.topicRegion.removeSubscription(context, info);
    }

    public void send(ConnectionContext context, Message message) throws Exception {
        message.getMessageId().setBrokerSequenceId(this.sequenceGenerator.getNextSequenceId());
        if (message.getTimestamp() > 0L && (message.getBrokerPath() == null || message.getBrokerPath().length == 0)) {
            message.setTimestamp(System.currentTimeMillis());
        }
        ActiveMQDestination destination = message.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.send(context, message);
                break;
            }
            case 2: {
                this.topicRegion.send(context, message);
                break;
            }
            case 5: {
                this.tempQueueRegion.send(context, message);
                break;
            }
            case 6: {
                this.tempTopicRegion.send(context, message);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        ActiveMQDestination destination = ack.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.acknowledge(context, ack);
                break;
            }
            case 2: {
                this.topicRegion.acknowledge(context, ack);
                break;
            }
            case 5: {
                this.tempQueueRegion.acknowledge(context, ack);
                break;
            }
            case 6: {
                this.tempTopicRegion.acknowledge(context, ack);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(brokerIdGenerator.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(ActiveMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    public synchronized void addBroker(Connection connection, BrokerInfo info) {
        this.brokerInfos.add((Object)info);
    }

    public synchronized void removeBroker(Connection connection, BrokerInfo info) {
        if (info != null) {
            this.brokerInfos.remove((Object)info);
        }
    }

    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        Object[] result = new BrokerInfo[this.brokerInfos.size()];
        result = (BrokerInfo[])this.brokerInfos.toArray(result);
        return result;
    }

    public void processDispatch(MessageDispatch messageDispatch) {
    }

    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        ActiveMQDestination destination = messageDispatchNotification.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 2: {
                this.topicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 5: {
                this.tempQueueRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            case 6: {
                this.tempTopicRegion.processDispatchNotification(messageDispatchNotification);
                break;
            }
            default: {
                throw this.createUnknownDestinationTypeException(destination);
            }
        }
    }

    public boolean isSlaveBroker() {
        return this.brokerService.isSlave();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Set getDurableDestinations() {
        return this.adaptor != null ? this.adaptor.getDestinations() : Collections.EMPTY_SET;
    }

    public boolean isFaultTolerantConfiguration() {
        return false;
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }
}

