/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractRegion;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicRegion
extends AbstractRegion {
    private static final Log log = LogFactory.getLog((Class)TopicRegion.class);
    protected final ConcurrentHashMap durableSubscriptions = new ConcurrentHashMap();
    private final LongSequenceGenerator recoveredDurableSubIdGenerator = new LongSequenceGenerator();
    private final SessionId recoveredDurableSubSessionId = new SessionId(new ConnectionId("OFFLINE"), this.recoveredDurableSubIdGenerator.getNextSequenceId());
    private boolean keepDurableSubsActive = false;

    public TopicRegion(RegionBroker broker, DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter persistenceAdapter) {
        super(broker, destinationStatistics, memoryManager, taskRunnerFactory, persistenceAdapter);
    }

    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        if (info.isDurable()) {
            String subcriptionName;
            String clientId;
            SubscriptionKey key;
            DurableTopicSubscription sub;
            ActiveMQDestination destination = info.getDestination();
            if (!destination.isPattern()) {
                this.lookup(context, destination);
            }
            if ((sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)(key = new SubscriptionKey(clientId = context.getClientId(), subcriptionName = info.getSubcriptionName())))) != null) {
                if (sub.isActive()) {
                    throw new JMSException("Durable consumer is in use for client: " + clientId + " and subscriptionName: " + subcriptionName);
                }
                if (this.hasDurableSubChanged(info, sub.getConsumerInfo())) {
                    this.durableSubscriptions.remove((Object)key);
                    Iterator iter = this.destinations.values().iterator();
                    while (iter.hasNext()) {
                        Topic topic = (Topic)iter.next();
                        topic.deleteSubscription(context, key);
                    }
                    super.removeConsumer(context, sub.getConsumerInfo());
                    super.addConsumer(context, info);
                    sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
                } else {
                    if (sub.getConsumerInfo().getConsumerId() != null) {
                        this.subscriptions.remove((Object)sub.getConsumerInfo().getConsumerId());
                    }
                    this.subscriptions.put((Object)info.getConsumerId(), (Object)sub);
                }
            } else {
                super.addConsumer(context, info);
                sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            }
            sub.activate(context, info);
            return sub;
        }
        return super.addConsumer(context, info);
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Exception {
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubcriptionName());
            DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            if (sub != null) {
                sub.deactivate(this.keepDurableSubsActive);
            }
        } else {
            super.removeConsumer(context, info);
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Exception {
        SubscriptionKey key = new SubscriptionKey(info.getClientId(), info.getSubcriptionName());
        DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
        if (sub == null) {
            throw new InvalidDestinationException("No durable subscription exists for: " + info.getSubcriptionName());
        }
        if (sub.isActive()) {
            throw new JMSException("Durable consumer is in use");
        }
        this.durableSubscriptions.remove((Object)key);
        Iterator iter = this.destinations.values().iterator();
        while (iter.hasNext()) {
            Topic topic = (Topic)iter.next();
            topic.deleteSubscription(context, key);
        }
        super.removeConsumer(context, sub.getConsumerInfo());
    }

    public String toString() {
        return "TopicRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }

    protected Destination createDestination(ConnectionContext context, ActiveMQDestination destination) throws Exception {
        TopicMessageStore store = null;
        if (!AdvisorySupport.isAdvisoryTopic(destination)) {
            store = this.persistenceAdapter.createTopicMessageStore((ActiveMQTopic)destination);
        }
        Topic topic = new Topic(destination, store, this.memoryManager, this.destinationStatistics, this.taskRunnerFactory);
        this.configureTopic(topic, destination);
        if (store != null) {
            SubscriptionInfo[] infos = store.getAllSubscriptions();
            for (int i = 0; i < infos.length; ++i) {
                SubscriptionInfo info = infos[i];
                log.debug((Object)("Restoring durable subscription: " + infos));
                SubscriptionKey key = new SubscriptionKey(info);
                DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
                ConsumerInfo consumerInfo = this.createInactiveConsumerInfo(info);
                if (sub == null) {
                    ConnectionContext c = new ConnectionContext();
                    c.setBroker(context.getBroker());
                    c.setClientId(key.getClientId());
                    c.setConnectionId(consumerInfo.getConsumerId().getParentId().getParentId());
                    sub = (DurableTopicSubscription)this.createSubscription(c, consumerInfo);
                }
                topic.addSubscription(context, sub);
            }
        }
        return topic;
    }

    private ConsumerInfo createInactiveConsumerInfo(SubscriptionInfo info) {
        ConsumerInfo rc = new ConsumerInfo();
        rc.setSelector(info.getSelector());
        rc.setSubcriptionName(info.getSubcriptionName());
        rc.setDestination(info.getDestination());
        rc.setConsumerId(this.createConsumerId());
        return rc;
    }

    private ConsumerId createConsumerId() {
        return new ConsumerId(this.recoveredDurableSubSessionId, this.recoveredDurableSubIdGenerator.getNextSequenceId());
    }

    protected void configureTopic(Topic topic, ActiveMQDestination destination) {
        PolicyEntry entry;
        if (this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure(topic);
        }
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws JMSException {
        PolicyEntry entry;
        if (info.isDurable()) {
            SubscriptionKey key = new SubscriptionKey(context.getClientId(), info.getSubcriptionName());
            DurableTopicSubscription sub = (DurableTopicSubscription)this.durableSubscriptions.get((Object)key);
            if (sub != null) {
                throw new JMSException("That durable subscription is already active.");
            }
            sub = new DurableTopicSubscription(this.broker, context, info, this.keepDurableSubsActive);
            this.durableSubscriptions.put((Object)key, (Object)sub);
            return sub;
        }
        TopicSubscription answer = new TopicSubscription(this.broker, context, info, this.memoryManager);
        ActiveMQDestination destination = info.getDestination();
        if (destination != null && this.broker.getDestinationPolicy() != null && (entry = this.broker.getDestinationPolicy().getEntryFor(destination)) != null) {
            entry.configure(answer);
        }
        return answer;
    }

    private boolean hasDurableSubChanged(ConsumerInfo info1, ConsumerInfo info2) {
        if (info1.getSelector() != null ^ info2.getSelector() != null) {
            return true;
        }
        if (info1.getSelector() != null && !info1.getSelector().equals(info2.getSelector())) {
            return true;
        }
        return !info1.getDestination().equals(info2.getDestination());
    }

    protected Set getInactiveDestinations() {
        Set inactiveDestinations = super.getInactiveDestinations();
        Iterator iter = inactiveDestinations.iterator();
        while (iter.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)iter.next();
            if (dest.isTopic()) continue;
            iter.remove();
        }
        return inactiveDestinations;
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
    }
}

