/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.thread.Scheduler;

public class TimedSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private static final int GC_INTERVAL = 1000;
    private final List buffer = Collections.synchronizedList(new LinkedList());
    private volatile long lastGCRun = System.currentTimeMillis();
    private long recoverDuration = 60000L;
    private final Runnable gcTask = new Runnable(){

        public void run() {
            TimedSubscriptionRecoveryPolicy.this.gc();
        }
    };

    public boolean add(ConnectionContext context, MessageReference message) throws Exception {
        this.buffer.add(new TimestampWrapper(message, this.lastGCRun));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, Topic topic, Subscription sub) throws Exception {
        ArrayList copy = new ArrayList(this.buffer);
        if (!copy.isEmpty()) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    TimestampWrapper timestampWrapper = (TimestampWrapper)iter.next();
                    MessageReference message = timestampWrapper.message;
                    msgContext.setDestination(message.getRegionDestination().getActiveMQDestination());
                    msgContext.setMessageReference(message);
                    if (!sub.matches(message, msgContext)) continue;
                    sub.add(timestampWrapper.message);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
        Scheduler.executePeriodically(this.gcTask, 1000L);
    }

    public void stop() throws Exception {
        Scheduler.cancel(this.gcTask);
    }

    public void gc() {
        this.lastGCRun = System.currentTimeMillis();
        while (this.buffer.size() > 0) {
            TimestampWrapper timestampWrapper = (TimestampWrapper)this.buffer.get(0);
            if (this.lastGCRun <= timestampWrapper.timestamp + this.recoverDuration) break;
            this.buffer.remove(0);
        }
    }

    public long getRecoverDuration() {
        return this.recoverDuration;
    }

    public void setRecoverDuration(long recoverDuration) {
        this.recoverDuration = recoverDuration;
    }

    public Message[] browse(ActiveMQDestination destination) throws Exception {
        ArrayList<Message> result = new ArrayList<Message>();
        ArrayList copy = new ArrayList(this.buffer);
        DestinationFilter filter = DestinationFilter.parseFilter(destination);
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            TimestampWrapper timestampWrapper = (TimestampWrapper)iter.next();
            MessageReference ref = timestampWrapper.message;
            Message message = ref.getMessage();
            if (!filter.matches(message.getDestination())) continue;
            result.add(message);
        }
        return result.toArray(new Message[result.size()]);
    }

    static class TimestampWrapper {
        public MessageReference message;
        public long timestamp;

        public TimestampWrapper(MessageReference message, long timestamp) {
            this.message = message;
            this.timestamp = timestamp;
        }
    }
}

