/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.BadMagicException;
import org.apache.activemq.kaha.impl.Item;

final class DataItem
implements Item {
    static final int HEAD_SIZE = 6;
    private int size;
    private long offset = -1L;
    private int file = -1;

    DataItem() {
    }

    boolean isValid() {
        return (long)this.file != -1L;
    }

    void writeHeader(DataOutput dataOut) throws IOException {
        dataOut.writeShort(31317);
        dataOut.writeInt(this.size);
    }

    void readHeader(DataInput dataIn) throws IOException {
        short magic = dataIn.readShort();
        if (magic != 31317) {
            throw new BadMagicException("Unexpected Magic value: " + magic);
        }
        this.size = dataIn.readInt();
    }

    void writePayload(Marshaller marshaller, Object object, DataOutputStream dataOut) throws IOException {
        marshaller.writePayload(object, dataOut);
    }

    Object readPayload(Marshaller marshaller, DataInputStream dataIn) throws IOException {
        return marshaller.readPayload(dataIn);
    }

    int getSize() {
        return this.size;
    }

    void setSize(int size) {
        this.size = size;
    }

    long getOffset() {
        return this.offset;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    int getFile() {
        return this.file;
    }

    void setFile(int file) {
        this.file = file;
    }

    public String toString() {
        String result = "offset = " + this.offset + ", file = " + this.file + ", size = " + this.size;
        return result;
    }
}

