/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import org.apache.activemq.kaha.impl.IndexItem;

final class IndexLinkedList
implements Cloneable {
    private transient IndexItem root;
    private transient int size = 0;

    IndexLinkedList(IndexItem header) {
        this.root.next = this.root.prev = (this.root = header);
    }

    IndexItem getRoot() {
        return this.root;
    }

    IndexItem getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.root.next;
    }

    IndexItem getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.root.prev;
    }

    IndexItem removeFirst() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.next;
        this.remove(this.root.next);
        return result;
    }

    Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.prev;
        this.remove(this.root.prev);
        return result;
    }

    void addFirst(IndexItem item) {
        this.addBefore(item, this.root.next);
    }

    void addLast(IndexItem item) {
        this.addBefore(item, this.root);
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    boolean add(IndexItem item) {
        this.addBefore(item, this.root);
        return true;
    }

    void clear() {
        this.root.next = this.root.prev = this.root;
        this.size = 0;
    }

    IndexItem get(int index) {
        return this.entry(index);
    }

    void add(int index, IndexItem element) {
        this.addBefore(element, index == this.size ? this.root : this.entry(index));
    }

    Object remove(int index) {
        IndexItem e = this.entry(index);
        this.remove(e);
        return e;
    }

    private IndexItem entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        IndexItem e = this.root;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.prev;
            }
        }
        return e;
    }

    int indexOf(IndexItem o) {
        int index = 0;
        IndexItem e = this.root.next;
        while (e != this.root) {
            if (o == e) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    IndexItem getNextEntry(IndexItem entry) {
        return entry.next != this.root ? entry.next : null;
    }

    IndexItem getPrevEntry(IndexItem entry) {
        return entry.prev != this.root ? entry.prev : null;
    }

    void addBefore(IndexItem insert, IndexItem e) {
        insert.next = e;
        insert.prev = e.prev;
        insert.prev.next = insert;
        insert.next.prev = insert;
        ++this.size;
    }

    void remove(IndexItem e) {
        if (e == this.root) {
            return;
        }
        e.prev.next = e.next;
        e.next.prev = e.prev;
        --this.size;
    }

    public Object clone() {
        IndexLinkedList clone = new IndexLinkedList(this.root);
        IndexItem e = this.root.next;
        while (e != this.root) {
            clone.add(e);
            e = e.next;
        }
        return clone;
    }
}

