/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.StoreIndexReader;
import org.apache.activemq.kaha.impl.StoreIndexWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class IndexManager {
    private static final Log log = LogFactory.getLog((Class)IndexManager.class);
    private File file;
    private RandomAccessFile indexFile;
    private StoreIndexReader reader;
    private StoreIndexWriter writer;
    private LinkedList freeList = new LinkedList();
    private long length = 0L;

    IndexManager(File ifile, String mode) throws IOException {
        this.file = ifile;
        this.indexFile = new RandomAccessFile(ifile, mode);
        this.reader = new StoreIndexReader(this.indexFile);
        this.writer = new StoreIndexWriter(this.indexFile);
        long offset = 0L;
        while (offset + 43L <= this.indexFile.length()) {
            IndexItem index = this.reader.readItem(offset);
            if (!index.isActive()) {
                index.reset();
                this.freeList.add(index);
            }
            offset += 43L;
        }
        this.length = offset;
    }

    synchronized boolean isEmpty() throws IOException {
        return this.freeList.isEmpty() && this.length == 0L;
    }

    synchronized IndexItem getIndex(long offset) throws IOException {
        return this.reader.readItem(offset);
    }

    synchronized void freeIndex(IndexItem item) throws IOException {
        item.reset();
        item.setActive(false);
        this.writer.storeItem(item);
        this.freeList.add(item);
    }

    synchronized void updateIndex(IndexItem index) throws IOException {
        this.writer.storeItem(index);
    }

    synchronized IndexItem createNewIndex() throws IOException {
        IndexItem result = this.getNextFreeIndex();
        if (result == null) {
            result = new IndexItem();
            result.setOffset(this.length);
            this.length += 43L;
        }
        return result;
    }

    synchronized void close() throws IOException {
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
    }

    synchronized void force() throws IOException {
        if (this.indexFile != null) {
            this.indexFile.getFD().sync();
        }
    }

    synchronized boolean delete() throws IOException {
        this.freeList.clear();
        if (this.indexFile != null) {
            this.indexFile.close();
            this.indexFile = null;
        }
        return this.file.delete();
    }

    private IndexItem getNextFreeIndex() throws IOException {
        IndexItem result = null;
        if (!this.freeList.isEmpty()) {
            result = (IndexItem)this.freeList.removeLast();
            result.reset();
        }
        return result;
    }

    long getLength() {
        return this.length;
    }

    void setLength(long value) {
        this.length = value;
    }
}

