/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.ObjectMarshaller;
import org.apache.activemq.kaha.RuntimeStoreException;
import org.apache.activemq.kaha.impl.BaseContainerImpl;
import org.apache.activemq.kaha.impl.ContainerId;
import org.apache.activemq.kaha.impl.ContainerListIterator;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.IndexItem;
import org.apache.activemq.kaha.impl.IndexManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class ListContainerImpl
extends BaseContainerImpl
implements ListContainer {
    private static final Log log = LogFactory.getLog((Class)ListContainerImpl.class);
    protected Marshaller marshaller = new ObjectMarshaller();

    protected ListContainerImpl(ContainerId id, IndexItem root, IndexManager indexManager, DataManager dataManager) throws IOException {
        super(id, root, indexManager, dataManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this.checkClosed();
        if (!this.loaded) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.loaded) {
                    this.loaded = true;
                    try {
                        long nextItem = this.root.getNextItem();
                        while (nextItem != -1L) {
                            IndexItem item = this.indexManager.getIndex(nextItem);
                            this.list.add(item);
                            nextItem = item.getNextItem();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)("Failed to load container " + this.getId()), (Throwable)e);
                        throw new RuntimeStoreException(e);
                    }
                }
            }
        }
    }

    public void unload() {
        this.checkClosed();
        if (this.loaded) {
            this.loaded = false;
            this.list.clear();
        }
    }

    public void setMarshaller(Marshaller marshaller) {
        this.checkClosed();
        this.marshaller = marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        this.load();
        boolean result = false;
        if (obj != null && obj instanceof List) {
            List other = (List)obj;
            Object object = this.mutex;
            synchronized (object) {
                boolean bl = result = other.size() == this.size();
                if (result) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        Object o2;
                        Object o1 = other.get(i);
                        boolean bl2 = result = o1 == (o2 = this.get(i)) || o1 != null && o2 != null && o1.equals(o2);
                        if (!result) break;
                    }
                }
            }
        }
        return result;
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(Object o) {
        this.load();
        IndexItem item = this.writeFirst(o);
        Object object = this.mutex;
        synchronized (object) {
            this.list.addFirst(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(Object o) {
        this.load();
        IndexItem item = this.writeLast(o);
        Object object = this.mutex;
        synchronized (object) {
            this.list.addLast(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFirst() {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.list.getFirst();
            if (item != null) {
                result = this.getValue(item);
                int index = this.list.indexOf(item);
                IndexItem prev = index > 0 ? this.list.get(index - 1) : this.root;
                IndexItem next = index < this.list.size() - 1 ? this.list.get(index + 1) : null;
                this.list.removeFirst();
                this.delete(item, prev, next);
                Object var3_3 = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeLast() {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.list.getLast();
            if (item != null) {
                result = this.getValue(item);
                int index = this.list.indexOf(item);
                IndexItem prev = index > 0 ? this.list.get(index - 1) : this.root;
                IndexItem next = null;
                this.list.removeLast();
                this.delete(item, prev, next);
                Object var3_3 = null;
            }
        }
        return result;
    }

    public boolean isEmpty() {
        this.load();
        return this.list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        this.load();
        boolean result = false;
        if (o != null) {
            Object object = this.mutex;
            synchronized (object) {
                IndexItem next = this.list.getFirst();
                while (next != null) {
                    Object value = this.getValue(next);
                    if (value != null && value.equals(o)) {
                        result = true;
                        break;
                    }
                    next = this.list.getNextEntry(next);
                }
            }
        }
        return result;
    }

    public Iterator iterator() {
        this.load();
        return this.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.list.size());
        Object object = this.mutex;
        synchronized (object) {
            IndexItem next = this.list.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                tmp.add(value);
                next = this.list.getNextEntry(next);
            }
        }
        return tmp.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        this.load();
        ArrayList<Object> tmp = new ArrayList<Object>(this.list.size());
        Object object = this.mutex;
        synchronized (object) {
            IndexItem next = this.list.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                tmp.add(value);
                next = this.list.getNextEntry(next);
            }
        }
        return tmp.toArray(a);
    }

    public boolean add(Object o) {
        this.load();
        this.addLast(o);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        this.load();
        boolean result = false;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem next = this.list.getFirst();
            while (next != null) {
                Object value = this.getValue(next);
                if (value != null && value.equals(o)) {
                    this.remove(next);
                    result = true;
                    break;
                }
                next = this.list.getNextEntry(next);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(IndexItem item) {
        Object object = this.mutex;
        synchronized (object) {
            int index = this.list.indexOf(item);
            IndexItem prev = index > 0 ? this.list.get(index - 1) : this.root;
            IndexItem next = index < this.list.size() - 1 ? this.list.get(index + 1) : null;
            this.list.remove(index);
            this.delete(item, prev, next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        this.load();
        boolean result = false;
        Object object = this.mutex;
        synchronized (object) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                result = this.contains(obj);
                if (result) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean addAll(Collection c) {
        this.load();
        boolean result = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection c) {
        this.load();
        boolean result = false;
        ListIterator e1 = this.listIterator(index);
        Iterator e2 = c.iterator();
        while (e2.hasNext()) {
            e1.add(e2.next());
            result = true;
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        this.load();
        boolean result = true;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            result &= this.remove(obj);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        this.load();
        ArrayList<Object> tmpList = new ArrayList<Object>();
        Object object = this.mutex;
        synchronized (object) {
            IndexItem next = this.list.getFirst();
            while (next != null) {
                Object o = this.getValue(next);
                if (!c.contains(o)) {
                    tmpList.add(o);
                }
                next = this.list.getNextEntry(next);
            }
        }
        Iterator i = tmpList.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
        return !tmpList.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.checkClosed();
        Object object = this.mutex;
        synchronized (object) {
            this.list.clear();
            this.doClear();
        }
    }

    public Object get(int index) {
        this.load();
        Object result = null;
        IndexItem item = this.list.get(index);
        if (item != null) {
            result = this.getValue(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem replace = this.list.isEmpty() ? null : this.list.get(index);
            IndexItem prev = this.list.isEmpty() || index - 1 < 0 ? null : this.list.get(index - 1);
            IndexItem next = this.list.isEmpty() || index + 1 >= this.size() ? null : this.list.get(index + 1);
            result = this.getValue(replace);
            this.list.remove(index);
            this.delete(replace, prev, next);
            this.add(index, element);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexItem internalSet(int index, Object element) {
        Object object = this.mutex;
        synchronized (object) {
            IndexItem replace = this.list.isEmpty() ? null : this.list.get(index);
            IndexItem prev = this.list.isEmpty() || index - 1 < 0 ? null : this.list.get(index - 1);
            IndexItem next = this.list.isEmpty() || index + 1 >= this.size() ? null : this.list.get(index + 1);
            this.list.remove(index);
            this.delete(replace, prev, next);
            return this.internalAdd(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        this.load();
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.insert(index, element);
            this.list.add(index, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexItem internalAdd(int index, Object element) {
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.insert(index, element);
            this.list.add(index, item);
            return item;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexItem internalGet(int index) {
        Object object = this.mutex;
        synchronized (object) {
            if (index >= 0 && index < this.list.size()) {
                return this.list.get(index);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRemove(int index) {
        this.load();
        boolean result = false;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.list.get(index);
            if (item != null) {
                result = true;
                IndexItem prev = this.list.getPrevEntry(item);
                prev = prev != null ? prev : this.root;
                IndexItem next = this.list.getNextEntry(prev);
                this.list.remove(index);
                this.delete(item, prev, next);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        this.load();
        Object result = null;
        Object object = this.mutex;
        synchronized (object) {
            IndexItem item = this.list.get(index);
            if (item != null) {
                result = this.getValue(item);
                IndexItem prev = this.list.getPrevEntry(item);
                prev = prev != null ? prev : this.root;
                IndexItem next = this.list.getNextEntry(prev);
                this.list.remove(index);
                this.delete(item, prev, next);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            Object object = this.mutex;
            synchronized (object) {
                int count = 0;
                IndexItem next = this.list.getFirst();
                while (next != null) {
                    Object value = this.getValue(next);
                    if (value != null && value.equals(o)) {
                        result = count;
                        break;
                    }
                    ++count;
                    next = this.list.getNextEntry(next);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        this.load();
        int result = -1;
        if (o != null) {
            Object object = this.mutex;
            synchronized (object) {
                int count = this.list.size() - 1;
                IndexItem next = this.list.getLast();
                while (next != null) {
                    Object value = this.getValue(next);
                    if (value != null && value.equals(o)) {
                        result = count;
                        break;
                    }
                    --count;
                    next = this.list.getPrevEntry(next);
                }
            }
        }
        return result;
    }

    public ListIterator listIterator() {
        this.load();
        return new ContainerListIterator(this, this.list, this.list.getRoot());
    }

    public ListIterator listIterator(int index) {
        this.load();
        IndexItem start = this.list.get(index);
        if (start != null) {
            start = this.list.getPrevEntry(start);
        }
        if (start == null) {
            start = this.root;
        }
        return new ContainerListIterator(this, this.list, start);
    }

    public List subList(int fromIndex, int toIndex) {
        this.load();
        ArrayList<Object> result = new ArrayList<Object>();
        int count = fromIndex;
        IndexItem next = this.list.get(fromIndex);
        while (next != null && count++ < toIndex) {
            result.add(this.getValue(next));
            next = this.list.getNextEntry(next);
        }
        return result;
    }

    protected IndexItem writeLast(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                DataItem data = this.dataManager.storeItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.list.getLast();
                prev = prev != null ? prev : this.root;
                IndexItem next = this.list.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndex(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.indexManager.updateIndex(next);
                }
                this.indexManager.updateIndex(index);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to write " + value), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected IndexItem writeFirst(Object value) {
        IndexItem index = null;
        try {
            if (value != null) {
                DataItem data = this.dataManager.storeItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = this.root;
                IndexItem next = this.list.getNextEntry(prev);
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndex(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.indexManager.updateIndex(next);
                }
                this.indexManager.updateIndex(index);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to write " + value), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected IndexItem insert(int insertPos, Object value) {
        long pos = -1L;
        IndexItem index = null;
        try {
            if (value != null) {
                DataItem data = this.dataManager.storeItem(this.marshaller, value);
                index = this.indexManager.createNewIndex();
                index.setValueData(data);
                IndexItem prev = null;
                IndexItem next = null;
                if (insertPos <= 0) {
                    prev = this.root;
                    next = this.list.getNextEntry(this.root);
                } else if (insertPos >= this.list.size()) {
                    prev = this.list.getLast();
                    next = null;
                } else {
                    prev = this.list.get(insertPos);
                    prev = prev != null ? prev : this.root;
                    next = this.list.getNextEntry(prev);
                }
                prev.setNextItem(index.getOffset());
                index.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndex(prev);
                if (next != null) {
                    next.setPreviousItem(index.getOffset());
                    index.setNextItem(next.getOffset());
                    this.indexManager.updateIndex(next);
                }
                this.indexManager.updateIndex(index);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to insert " + value), (Throwable)e);
            throw new RuntimeStoreException(e);
        }
        return index;
    }

    protected Object getValue(IndexItem item) {
        Object result = null;
        if (item != null) {
            try {
                DataItem data = item.getValueDataItem();
                result = this.dataManager.readItem(this.marshaller, data);
            }
            catch (IOException e) {
                log.error((Object)("Failed to get value for " + item), (Throwable)e);
                throw new RuntimeStoreException(e);
            }
        }
        return result;
    }
}

