/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.DataItem;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.StoreByteArrayInputStream;

final class StoreDataReader {
    private DataManager dataManager;
    private StoreByteArrayInputStream dataIn;
    private byte[] header = new byte[6];

    StoreDataReader(DataManager fileManager) {
        this.dataManager = fileManager;
        this.dataIn = new StoreByteArrayInputStream();
    }

    protected Object readItem(Marshaller marshaller, DataItem item) throws IOException {
        RandomAccessFile file = this.dataManager.getDataFile(item);
        file.seek(item.getOffset());
        file.readFully(this.header);
        this.dataIn.restart(this.header);
        item.readHeader(this.dataIn);
        byte[] data = new byte[item.getSize()];
        file.readFully(data);
        this.dataIn.restart(data);
        return marshaller.readPayload(this.dataIn);
    }
}

